/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationConstants;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectStatesApi;
import com.xtm.aem.rest.openapi.model.RSJobStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import com.xtm.aem.rest.openapi.model.RSStepStatusResponse;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainJobTranslationStatusRestAction
extends BaseXtmRestAction<Map<Long, TranslationConstants.TranslationStatus>> {
    private static final Logger log = LoggerFactory.getLogger(ObtainJobTranslationStatusRestAction.class);
    private final Long projectId;
    private final Collection<Long> jobIds;

    public ObtainJobTranslationStatusRestAction(Long projectId, Collection<Long> jobIds, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
        this.jobIds = jobIds;
    }

    @Override
    protected Map<Long, TranslationConstants.TranslationStatus> runInternal() throws Exception {
        log.trace("ObtainJobTranslationStatusRestAction.runInternal");
        ProjectStatesApi projectStatesApi = new ProjectStatesApi(this.getApiClient());
        RSProjectStatusResponse projectStatusResponse = projectStatesApi.checkProjectStatusesUsingGET(this.getAccessToken(), this.projectId, "STEPS", null, null, null);
        return projectStatusResponse.getJobs().stream().filter(Objects::nonNull).filter(rsJobStatusResponse -> this.jobIds.contains(rsJobStatusResponse.getJobId())).collect(Collectors.toMap(RSJobStatusResponse::getJobId, this::mapXTMJobStatusToAEMTranslationStatus));
    }

    private TranslationConstants.TranslationStatus mapXTMJobStatusToAEMTranslationStatus(@Nonnull RSJobStatusResponse jobResponse) {
        switch (jobResponse.getCompletionStatus()) {
            case ERROR: {
                return TranslationConstants.TranslationStatus.ERROR_UPDATE;
            }
            case FINISHED: {
                return TranslationConstants.TranslationStatus.TRANSLATED;
            }
            case IN_PROGRESS: {
                if (this.hasAnyJobStepStarted(jobResponse)) {
                    return TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS;
                }
                return TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION;
            }
        }
        return TranslationConstants.TranslationStatus.UNKNOWN_STATE;
    }

    private boolean hasAnyJobStepStarted(@Nonnull RSJobStatusResponse jobResponse) {
        boolean anyStepStarted = false;
        for (RSStepStatusResponse stepStatus : jobResponse.getSteps()) {
            if (stepStatus.getStatus().equals((Object)RSStepStatusResponse.StatusEnum.NOT_STARTED)) continue;
            anyStepStarted = true;
            break;
        }
        return anyStepStarted;
    }
}

