/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectLinksApi;
import com.xtm.aem.rest.openapi.model.RSProjectEditorLinkRequest;
import com.xtm.aem.rest.openapi.model.RSProjectEditorLinkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainProjectScopeDetailsLinkRestAction
extends BaseXtmRestAction<String> {
    private static final Logger log = LoggerFactory.getLogger(ObtainProjectScopeDetailsLinkRestAction.class);
    private final Long projectId;

    protected ObtainProjectScopeDetailsLinkRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
    }

    @Override
    protected String runInternal() throws Exception {
        log.trace("ObtainProjectScopeRestAction.runInternal");
        ProjectLinksApi projectLinksApi = new ProjectLinksApi(this.getApiClient());
        RSProjectEditorLinkRequest options = this.buildOptions();
        RSProjectEditorLinkResponse response = projectLinksApi.generateProjectEditorLinkUsingPOST(this.getAccessToken(), this.projectId, options);
        return response.getUrl();
    }

    private RSProjectEditorLinkRequest buildOptions() {
        RSProjectEditorLinkRequest options = new RSProjectEditorLinkRequest();
        options.setDefaultSection(RSProjectEditorLinkRequest.DefaultSectionEnum.METRICS);
        options.estimates(RSProjectEditorLinkRequest.EstimatesEnum.SHOW);
        options.setMetrics(RSProjectEditorLinkRequest.MetricsEnum.SHOW);
        options.setFiles(RSProjectEditorLinkRequest.FilesEnum.HIDE);
        options.setGeneral(RSProjectEditorLinkRequest.GeneralEnum.HIDE);
        options.setStatistics(RSProjectEditorLinkRequest.StatisticsEnum.HIDE);
        options.setWorkflow(RSProjectEditorLinkRequest.WorkflowEnum.HIDE);
        options.setLqa(RSProjectEditorLinkRequest.LqaEnum.HIDE);
        return options;
    }
}

