/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationConstants;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectStatesApi;
import com.xtm.aem.rest.openapi.model.RSJobStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import com.xtm.aem.rest.openapi.model.RSStepStatusResponse;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainProjectTranslationStatusRestAction
extends BaseXtmRestAction<TranslationConstants.TranslationStatus> {
    private static final Logger log = LoggerFactory.getLogger(ObtainProjectTranslationStatusRestAction.class);
    private final Long projectId;

    protected ObtainProjectTranslationStatusRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
    }

    @Override
    protected TranslationConstants.TranslationStatus runInternal() throws Exception {
        log.trace("ObtainProjectTranslationStatusRestAction.runInternal");
        log.debug("Obtaining project translation status for ID: {}", (Object)this.projectId);
        ProjectStatesApi projectStatesApi = new ProjectStatesApi(this.getApiClient());
        RSProjectStatusResponse response = projectStatesApi.checkProjectStatusesUsingGET(this.getAccessToken(), this.projectId, "STEPS", null, null, null);
        if (response != null && response.getActivity() != null) {
            switch (response.getActivity()) {
                case ARCHIVED: 
                case AUTO_ARCHIVED: {
                    log.debug("Project with Id: {}, was archived in XTM.", (Object)this.projectId);
                    return TranslationConstants.TranslationStatus.ARCHIVE;
                }
                case DELETED: {
                    log.debug("Project with Id: {}, was cancelled or deleted in XTM.", (Object)this.projectId);
                    return TranslationConstants.TranslationStatus.CANCEL;
                }
                case INACTIVE: {
                    log.debug("Project with Id: {}, is in unknown state", (Object)this.projectId);
                    return TranslationConstants.TranslationStatus.UNKNOWN_STATE;
                }
            }
            return this.getTranslationStatusFromResponse(response);
        }
        throw new XtmConnectorException("Unexpected response while checking completion status in XTM.");
    }

    private TranslationConstants.TranslationStatus getTranslationStatusFromResponse(RSProjectStatusResponse response) {
        TranslationConstants.TranslationStatus aemStatus;
        RSProjectStatusResponse.CompletionStatusEnum projectStatus = response.getCompletionStatus();
        switch (projectStatus) {
            case FINISHED: {
                log.debug("Project with Id: {}, is finished.", (Object)this.projectId);
                aemStatus = TranslationConstants.TranslationStatus.TRANSLATED;
                break;
            }
            case IN_PROGRESS: 
            case PARTIALLY_FINISHED: {
                log.debug("Project with Id: {}, is in progress.", (Object)this.projectId);
                aemStatus = response.getJobs().stream().map(RSJobStatusResponse::getSteps).filter(Objects::nonNull).flatMap(Collection::stream).map(RSStepStatusResponse::getStatus).allMatch(RSStepStatusResponse.StatusEnum.NOT_STARTED::equals) ? TranslationConstants.TranslationStatus.SUBMITTED : TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS;
                break;
            }
            default: {
                log.debug("Project with Id: {}, is in unknown state", (Object)this.projectId);
                aemStatus = TranslationConstants.TranslationStatus.UNKNOWN_STATE;
            }
        }
        log.debug("XTM project status: {}, converting to Translation Status: {}", (Object)projectStatus, (Object)aemStatus);
        return aemStatus;
    }
}

