/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectStatesApi;
import com.xtm.aem.rest.openapi.model.RSProjectAnalysisResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAnalysisCompletionRestAction
extends BaseXtmRestAction<RSProjectAnalysisResponse> {
    private static final Logger log = LoggerFactory.getLogger(ProjectAnalysisCompletionRestAction.class);
    private final Long projectId;
    private final int analysisCheckMaxRetries;
    private final int analysisCheckRetryInterval;

    protected ProjectAnalysisCompletionRestAction(Long projectId, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
        this.analysisCheckMaxRetries = cloudConfig.getAnalysisCheckMaxRetries();
        this.analysisCheckRetryInterval = cloudConfig.getAnalysisCheckRetryInterval();
    }

    @Override
    protected RSProjectAnalysisResponse runInternal() throws Exception {
        log.trace("ProjectAnalysisCompletionRestAction.runInternal");
        ProjectStatesApi projectStatesApi = new ProjectStatesApi(this.getApiClient());
        RSProjectAnalysisResponse response = null;
        for (int i = 0; i < this.analysisCheckMaxRetries; ++i) {
            response = projectStatesApi.checkProjectAnalysisCompletionUsingGET(this.getAccessToken(), this.projectId, null);
            log.debug("Project [{}],analysis status: {}", (Object)this.projectId, (Object)response.getStatus());
            if (response.getStatus() == RSProjectAnalysisResponse.StatusEnum.FINISHED) break;
            Thread.sleep(this.analysisCheckRetryInterval);
        }
        if (response.getStatus() != RSProjectAnalysisResponse.StatusEnum.FINISHED) {
            throw new XtmConnectorException("Maximum number of retries exceeded while checking for analysis completion in XTM");
        }
        return response;
    }
}

