/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.google.common.collect.Lists;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectFilesApi;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGEDEFINITIONS;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveTranslationResultAsInputStreamRestAction
extends BaseXtmRestAction<InputStream> {
    private static final Logger log = LoggerFactory.getLogger(RetrieveTranslationResultAsInputStreamRestAction.class);
    private final Long jobId;
    private final Long projectId;
    private final CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguageCode;
    private final String originalFileName;
    private final String prefixedFileName;
    private final RestActionFactory restActionFactory;

    protected RetrieveTranslationResultAsInputStreamRestAction(Long projectId, Long jobId, String originalFileName, CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguageCode, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper, RestActionFactory restActionFactory) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
        this.jobId = jobId;
        this.targetLanguageCode = targetLanguageCode;
        this.originalFileName = this.constructFileName(originalFileName);
        this.prefixedFileName = this.constructPrefixedFileName(targetLanguageCode, this.originalFileName);
        this.restActionFactory = restActionFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected InputStream runInternal() throws Exception {
        log.trace("RetrieveTranslationResultAsInputStreamRestAction.runInternal");
        ProjectFilesApi projectFilesApi = new ProjectFilesApi(this.getApiClient());
        File result = projectFilesApi.downloadFilesUsingGET(this.getAccessToken(), "JOB", "TARGET", this.projectId, null, null, null, Lists.newArrayList((Object[])new Long[]{this.jobId}), Lists.newArrayList((Object[])new String[]{this.targetLanguageCode.getValue()}));
        if (result == null) {
            log.error("Failed to obtain translation result files for projectId: {}, jobId: {}", (Object)this.projectId, (Object)this.jobId);
            return null;
        }
        log.info("Downloading translation result successful, for projectId: {}, jobId: {}, path: {}", new Object[]{this.projectId, this.jobId, result.getPath()});
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(result), StandardCharsets.UTF_8);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (this.entryHasMatchingName(entry)) {
                    ZipInputStream zipInputStream = zis;
                    return zipInputStream;
                }
                entry = zis.getNextEntry();
            }
            throw new XtmConnectorException("XTM response did not contain file for job '" + this.jobId + "'");
        }
        catch (IOException e) {
            throw new XtmConnectorException("Error while reading result file from XTM.");
        }
    }

    private boolean entryHasMatchingName(ZipEntry entry) {
        String rawEntryName = entry.getName();
        String entryName = rawEntryName.charAt(0) == '/' ? rawEntryName.substring(1) : rawEntryName;
        return StringUtils.equals((CharSequence)this.prefixedFileName, (CharSequence)entryName) || StringUtils.equals((CharSequence)this.originalFileName, (CharSequence)entryName);
    }

    private String constructPrefixedFileName(CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguageCode, String originalFileName) {
        return targetLanguageCode.getValue() + '/' + this.originalFileName;
    }

    private String constructFileName(String originalFileName) {
        return originalFileName.charAt(0) == '/' ? originalFileName.substring(1) : originalFileName;
    }
}

