/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.DueDatesJobModel;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectWorkflowsApi;
import com.xtm.aem.rest.openapi.model.RSProjectDueDateUpdateRequest;
import com.xtm.aem.rest.openapi.model.RSProjectDueDateUpdateResponse;
import com.xtm.aem.rest.openapi.model.RSProjectJobDueDateRequest;
import com.xtm.aem.rest.overrides.RestApiConstants;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDueDatesRestAction
extends BaseXtmRestAction<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(UpdateDueDatesRestAction.class);
    private final Long projectId;
    private final Collection<DueDatesJobModel> jobs;
    private final Date projectDueDate;
    private final ProjectWorkflowsApi projectWorkflowsApi;

    protected UpdateDueDatesRestAction(Long projectId, Date projectDueDate, Collection<DueDatesJobModel> jobs, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper, ProjectWorkflowsApi projectWorkflowsApi) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
        this.jobs = (Collection)ObjectUtils.defaultIfNull(jobs, Collections.emptyList());
        this.projectDueDate = projectDueDate;
        this.projectWorkflowsApi = projectWorkflowsApi;
    }

    @Override
    protected Boolean runInternal() throws Exception {
        log.trace("UpdateDueDatesRestAction.runInternal");
        this.projectWorkflowsApi.setApiClient(this.getApiClient());
        RSProjectDueDateUpdateResponse response = this.projectWorkflowsApi.updateDueDatesUsingPUT(this.getAccessToken(), this.projectId, this.getDueDateObject(), null);
        return response.getSuccess();
    }

    private RSProjectDueDateUpdateRequest getDueDateObject() {
        RSProjectDueDateUpdateRequest dueDateRequest = new RSProjectDueDateUpdateRequest();
        DateFormat format = RestApiConstants.getDateFormat();
        if (this.projectDueDate != null) {
            dueDateRequest.setProjectDueDate(format.format(this.projectDueDate));
        }
        for (DueDatesJobModel job : this.jobs) {
            RSProjectJobDueDateRequest dueDateJob = new RSProjectJobDueDateRequest();
            dueDateJob.setId(job.getId());
            dueDateJob.setDueDate(format.format(job.getDueDate()));
            dueDateRequest.addJobsItem(dueDateJob);
        }
        return dueDateRequest;
    }
}

