/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.rest.actions.BaseXtmRestAction;
import com.xtm.aem.rest.openapi.api.ProjectsApi;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesAddRequest;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesAddResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateProjectTargetLanguageRestAction
extends BaseXtmRestAction<RSProjectTargetLanguagesAddResponse> {
    private static final Logger log = LoggerFactory.getLogger(UpdateProjectTargetLanguageRestAction.class);
    private final Long projectId;
    private final RSProjectTargetLanguagesAddRequest targetLanguagesAddRequest;

    public UpdateProjectTargetLanguageRestAction(Long projectId, List<String> targetLanguages, TranslationCloudConfig cloudConfig, RestServicesWrapper restServicesWrapper) {
        super(cloudConfig, restServicesWrapper);
        this.projectId = projectId;
        this.targetLanguagesAddRequest = new RSProjectTargetLanguagesAddRequest();
        this.targetLanguagesAddRequest.setJobsCreationType(RSProjectTargetLanguagesAddRequest.JobsCreationTypeEnum.NO_JOBS);
        this.targetLanguagesAddRequest.setTargetLanguages(targetLanguages);
    }

    @Override
    protected RSProjectTargetLanguagesAddResponse runInternal() throws Exception {
        log.trace("UpdateProjectTargetLanguageRestAction.runInternal");
        ProjectsApi projectsApi = new ProjectsApi(this.getApiClient());
        return projectsApi.addTargetLanguagesUsingPOST(this.getAccessToken(), this.projectId, this.targetLanguagesAddRequest);
    }
}

