/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.actions;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationScope;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.XtmAction;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.DueDatesJobModel;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.rest.RestServicesWrapper;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.rest.actions.AddPreviewRestAction;
import com.xtm.aem.rest.actions.CancelProjectRestAction;
import com.xtm.aem.rest.actions.CreateProjectRestAction;
import com.xtm.aem.rest.actions.CustomersListRestAction;
import com.xtm.aem.rest.actions.DeleteTranslationFilesRestAction;
import com.xtm.aem.rest.actions.ObtainJobTranslationStatusRestAction;
import com.xtm.aem.rest.actions.ObtainProjectScopeDetailsLinkRestAction;
import com.xtm.aem.rest.actions.ObtainProjectScopeRestAction;
import com.xtm.aem.rest.actions.ObtainProjectStatusRestAction;
import com.xtm.aem.rest.actions.ObtainProjectTranslationStatusRestAction;
import com.xtm.aem.rest.actions.ProjectActivateRestAction;
import com.xtm.aem.rest.actions.ProjectAnalysisCompletionRestAction;
import com.xtm.aem.rest.actions.ProjectCompletionRestAction;
import com.xtm.aem.rest.actions.ProjectTemplatesListRestAction;
import com.xtm.aem.rest.actions.RetrieveTranslationResultAsInputStreamRestAction;
import com.xtm.aem.rest.actions.StartProjectRestAction;
import com.xtm.aem.rest.actions.UpdateDueDatesRestAction;
import com.xtm.aem.rest.actions.UpdateProjectTargetLanguageRestAction;
import com.xtm.aem.rest.actions.UploadTranslationFileToProjectRestAction;
import com.xtm.aem.rest.actions.XtmSystemInfoAction;
import com.xtm.aem.rest.openapi.api.ProjectWorkflowsApi;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGEDEFINITIONS;
import com.xtm.aem.rest.openapi.model.RSFindCustomerResponse;
import com.xtm.aem.rest.openapi.model.RSProjectAnalysisResponse;
import com.xtm.aem.rest.openapi.model.RSProjectCreationResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileUploadResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesAddResponse;
import com.xtm.aem.rest.openapi.model.RSProjectTemplateResponse;
import com.xtm.aem.rest.openapi.model.RSProjectWorkflowStartResponse;
import com.xtm.aem.rest.openapi.model.RSSystemInfoResponse;
import com.xtm.aem.rest.openapi.model.RSUploadPreviewFileResponse;
import com.xtm.aem.rest.overrides.ProjectFilesApiMatchType;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class XtmRestActionFactory
implements RestActionFactory {
    @Reference
    private RestServicesWrapper restServicesWrapper;

    @Override
    public XtmAction<RSProjectTargetLanguagesAddResponse> getUpdateProjectTargetLanguageAction(Long projectId, List<String> languagesToAdd, TranslationCloudConfig config) {
        return new UpdateProjectTargetLanguageRestAction(projectId, languagesToAdd, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<RSUploadPreviewFileResponse> getAddPreviewAction(Long projectId, PreviewZipFile previewFile, TranslationCloudConfig config) {
        XtmAction<RSProjectAnalysisResponse> projectAnalysisCompletionRestAction = this.getProjectAnalysisCompletionAction(projectId, config);
        return new AddPreviewRestAction(projectId, previewFile, config, this.restServicesWrapper, projectAnalysisCompletionRestAction);
    }

    @Override
    public XtmAction<RSProjectAnalysisResponse> getProjectAnalysisCompletionAction(Long projectId, TranslationCloudConfig config) {
        return new ProjectAnalysisCompletionRestAction(projectId, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<TranslationConstants.TranslationStatus> getObtainProjectTranslationStatusAction(Long projectId, TranslationCloudConfig config) {
        return new ObtainProjectTranslationStatusRestAction(projectId, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<RSProjectStatusResponse> getObtainProjectStatusAction(Long projectId, TranslationCloudConfig config) {
        return new ObtainProjectStatusRestAction(projectId, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<RSProjectCreationResponse> getCreateProjectAction(AemTranslationJob atj) {
        return new CreateProjectRestAction(atj, atj.getProject().getConfig(), this.restServicesWrapper, this);
    }

    @Override
    public XtmAction<RSProjectFileUploadResponse> getUploadTranslationFileToProjectAction(Long xtmProjectId, List<AemTranslationObject> aemTranslationObjects, ProjectFilesApiMatchType matchType, TranslationCloudConfig cloudConfig) {
        return new UploadTranslationFileToProjectRestAction(xtmProjectId, aemTranslationObjects, cloudConfig, matchType, this.restServicesWrapper);
    }

    @Override
    public XtmAction<RSProjectWorkflowStartResponse> getStartProjectAction(Long projectId, List<Long> jobIds, TranslationCloudConfig cloudConfig) {
        XtmAction<RSProjectAnalysisResponse> projectAnalysisCompletionRestAction = this.getProjectAnalysisCompletionAction(projectId, cloudConfig);
        return new StartProjectRestAction(projectId, jobIds, cloudConfig, this.restServicesWrapper, projectAnalysisCompletionRestAction);
    }

    @Override
    public XtmAction<RSProjectStatusResponse> getCheckProjectCompletionAction(Long projectId, TranslationCloudConfig cloudConfig) {
        XtmAction<RSProjectAnalysisResponse> projectAnalysisCompletionRestAction = this.getProjectAnalysisCompletionAction(projectId, cloudConfig);
        return new ProjectCompletionRestAction(projectId, cloudConfig, this.restServicesWrapper, projectAnalysisCompletionRestAction);
    }

    @Override
    public XtmAction<RSProjectFileDeleteResponse> getDeleteTranslationFilesAction(Long projectId, Collection<CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum> targetLanguages, Collection<String> filesToDelete, TranslationCloudConfig cloudConfig) {
        XtmAction<RSProjectAnalysisResponse> projectAnalysisCompletionRestAction = this.getProjectAnalysisCompletionAction(projectId, cloudConfig);
        XtmAction<RSProjectStatusResponse> checkProjectCompletionAction = this.getCheckProjectCompletionAction(projectId, cloudConfig);
        return new DeleteTranslationFilesRestAction(projectId, targetLanguages, filesToDelete, cloudConfig, this.restServicesWrapper, projectAnalysisCompletionRestAction, checkProjectCompletionAction);
    }

    @Override
    public XtmAction<Map<Long, Boolean>> getCancelProjectAction(Collection<Long> projectIds, TranslationCloudConfig config) {
        return new CancelProjectRestAction(projectIds, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<TranslationScope> getObtainProjectScopeAction(Long projectId, CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguage, TranslationCloudConfig config) {
        return new ObtainProjectScopeRestAction(projectId, targetLanguage, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<String> getObtainProjectScopeDetailsLinkAction(Long projectId, TranslationCloudConfig config) {
        return new ObtainProjectScopeDetailsLinkRestAction(projectId, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<Boolean> getProjectActivateAction(Long projectId, TranslationCloudConfig config) {
        return new ProjectActivateRestAction(projectId, config, this.restServicesWrapper, this.getObtainProjectStatusAction(projectId, config));
    }

    @Override
    public XtmAction<InputStream> getRetrieveTranslationResultAsInputStreamAction(Long projectId, Long jobId, String originalFileName, CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguageCode, TranslationCloudConfig config) {
        return new RetrieveTranslationResultAsInputStreamRestAction(projectId, jobId, originalFileName, targetLanguageCode, config, this.restServicesWrapper, this);
    }

    @Override
    public XtmAction<RSSystemInfoResponse> getXtmSystemInfoAction(TranslationCloudConfig config) {
        return new XtmSystemInfoAction(config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<Map<Long, TranslationConstants.TranslationStatus>> getObtainJobTranslationStatusAction(Long projectId, Collection<Long> jobIds, TranslationCloudConfig config) {
        return new ObtainJobTranslationStatusRestAction(projectId, jobIds, config, this.restServicesWrapper);
    }

    @Override
    public XtmAction<Boolean> getUpdateDueDatesAction(Long projectId, Date projectDueDate, List<DueDatesJobModel> jobs, TranslationCloudConfig config) {
        return new UpdateDueDatesRestAction(projectId, projectDueDate, jobs, config, this.restServicesWrapper, new ProjectWorkflowsApi());
    }

    @Override
    public XtmAction<List<RSFindCustomerResponse>> getCustomerList(TranslationCloudConfig cloudConfig) {
        return new CustomersListRestAction(cloudConfig, this.restServicesWrapper);
    }

    @Override
    public XtmAction<List<RSProjectTemplateResponse>> getProjectTemplateList(Long customerId, TranslationCloudConfig cloudConfig) {
        return new ProjectTemplatesListRestAction(customerId, cloudConfig, this.restServicesWrapper);
    }
}

