/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.rest.services.ServletHelper;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=XTM Create project", "sling.servlet.methods=POST", "sling.servlet.paths=/services/xtm/project-scope-details-link"})
public class ProjectScopeDetailsLinkServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ProjectScopeDetailsLinkServlet.class);
    public static final String SERVLET_PATH = "/services/xtm/project-scope-details-link";
    static final String PROJECT_ID_PARAM = "projectId";
    static final String MSG_MISSING_PROJECT_ID_PARAMETER = "Please specify a valid projectId query parameter";
    static final String MSG_FAILED_TO_PARSE_PROJECT_ID = "Failed to parse projectId param";
    static final String MSG_FAILED_TO_EXECUTE_REST = "Failed to execute REST action";
    @Reference
    private RestActionFactory restActionFactory;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String projectIdParam = request.getParameter(PROJECT_ID_PARAM);
        if (StringUtils.isBlank((CharSequence)projectIdParam)) {
            ServletHelper.writeErrorBadRequest(MSG_MISSING_PROJECT_ID_PARAMETER, response);
            return;
        }
        TranslationCloudConfig cc = ServletHelper.getAndValidateTranslationCloudConfig(request, response);
        if (cc == null) {
            return;
        }
        try {
            Long projectId = Long.parseLong(projectIdParam);
            String redirectUrl = this.restActionFactory.getObtainProjectScopeDetailsLinkAction(projectId, cc).run();
            response.sendRedirect(redirectUrl);
        }
        catch (NumberFormatException e) {
            log.error("Failed to parse projectId param '{}'", (Object)projectIdParam, (Object)e);
            ServletHelper.writeErrorBadRequest(MSG_FAILED_TO_PARSE_PROJECT_ID, response);
        }
        catch (TranslationException e) {
            log.error(MSG_FAILED_TO_EXECUTE_REST, (Throwable)e);
            ServletHelper.writeErrorBadRequest(MSG_FAILED_TO_EXECUTE_REST, response);
        }
    }
}

