/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.models.config.TranslationCloudConfigUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

public class ServletHelper {
    static final String CONFIGURATION_PATH_PARAM = "configurationPath";
    static final String INVALID_QUERY_PARAMETER_MSG = "Please specify configurationPath query parameter that points to a valid XTM configuration.";
    static final String FAILED_TO_OBTAIN_CC_MSG = "Failed to obtain XTM Translation Cloud Configuration";
    static final String FAILED_TO_VALIDATE_CC = "Provided cloud configuration is invalid. Please ensure that required fields are set.";

    public static void writeErrorBadRequest(String msg, SlingHttpServletResponse response) throws IOException {
        ServletHelper.writeError(msg, 400, response);
    }

    public static void writeErrorNotFound(String msg, SlingHttpServletResponse response) throws IOException {
        ServletHelper.writeError(msg, 404, response);
    }

    public static void writeErrorUnauthorized(String msg, SlingHttpServletResponse response) throws IOException {
        ServletHelper.writeError(msg, 401, response);
    }

    public static void writeErrorInternalServerError(String msg, SlingHttpServletResponse response) throws IOException {
        ServletHelper.writeError(msg, 500, response);
    }

    public static void writeError(String msg, int httpStatusCode, SlingHttpServletResponse response) throws IOException {
        response.setStatus(httpStatusCode);
        ServletHelper.write(msg, response);
    }

    public static void write(String message, SlingHttpServletResponse response) throws IOException {
        response.getWriter().write(message);
    }

    public static void writeJson(Object object, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.getWriter().write(new ObjectMapper().writeValueAsString(object));
    }

    public static TranslationCloudConfig getAndValidateTranslationCloudConfig(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String xtmConfPath = request.getParameter(CONFIGURATION_PATH_PARAM);
        if (StringUtils.isBlank((CharSequence)xtmConfPath)) {
            ServletHelper.writeErrorBadRequest(INVALID_QUERY_PARAMETER_MSG, response);
            return null;
        }
        TranslationCloudConfig cc = TranslationCloudConfigUtil.getTranslationCloudConfig(request, xtmConfPath);
        if (cc == null) {
            ServletHelper.writeErrorNotFound(FAILED_TO_OBTAIN_CC_MSG, response);
            return null;
        }
        if (!TranslationCloudConfigUtil.isValid(cc)) {
            ServletHelper.writeErrorUnauthorized(FAILED_TO_VALIDATE_CC, response);
            return null;
        }
        return cc;
    }

    private ServletHelper() {
    }
}

