/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestConnectionStatus;
import com.xtm.aem.api.rest.RestConnectionStatusService;
import com.xtm.aem.rest.services.ServletHelper;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.vendor=Xtm Intl", "sling.servlet.methods=GET", "sling.servlet.paths=/services/xtm/rest-connection-test"})
public class XtmRestConnectionStatusServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(XtmRestConnectionStatusServlet.class);
    static final String SERVLET_PATH = "/services/xtm/rest-connection-test";
    @Reference
    private RestConnectionStatusService restConnectionStatusService;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        TranslationCloudConfig cc = ServletHelper.getAndValidateTranslationCloudConfig(request, response);
        if (cc == null) {
            return;
        }
        RestConnectionStatus connectionStatus = this.restConnectionStatusService.getConnectionStatus(cc);
        if (connectionStatus.isConnected()) {
            response.setStatus(200);
        } else {
            response.setStatus(400);
        }
        ServletHelper.writeJson(connectionStatus, response);
    }
}

