/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.services;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.OauthAccessTokenModel;
import com.xtm.aem.api.rest.OauthClientDataProvider;
import com.xtm.aem.api.rest.RestClientFactory;
import com.xtm.aem.api.rest.RestTokenManager;
import com.xtm.aem.api.rest.RestTokenStore;
import com.xtm.aem.models.config.TranslationCloudConfigUtil;
import com.xtm.aem.rest.client.OauthApi;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", field="$$scr$$dummy$$field", service=AuthorInstance.class)})
public class XtmRestTokenManager
implements RestTokenManager {
    private static final Logger log = LoggerFactory.getLogger(XtmRestTokenManager.class);
    static final String MSG_API_EXCEPTION = "API Exception while processing XTM translation cloud config. Please check translation cloud configuration.";
    static final String MSG_INVALID_XTM_CC = "Invalid Translation Cloud Configuration provided";
    @Reference
    private RestClientFactory clientFactory;
    @Reference
    private OauthClientDataProvider clientDataProvider;
    @Reference
    private RestTokenStore tokenStore;

    @Override
    public boolean obtainOrRefreshToken(TranslationCloudConfig cloudConfig) {
        if (!TranslationCloudConfigUtil.isValid(cloudConfig)) {
            log.warn(MSG_INVALID_XTM_CC);
            return false;
        }
        OauthAccessTokenModel token = this.tokenStore.getTokenResponse(cloudConfig);
        if (this.shouldRefreshToken(token)) {
            return this.refreshToken(cloudConfig);
        }
        return this.obtainToken(cloudConfig);
    }

    @Override
    public boolean obtainToken(TranslationCloudConfig cloudConfig) {
        if (!TranslationCloudConfigUtil.isValid(cloudConfig)) {
            log.warn(MSG_INVALID_XTM_CC);
            return false;
        }
        try {
            ApiClient apiClient = this.clientFactory.create(cloudConfig);
            OauthApi oAuthApi = new OauthApi(apiClient);
            OauthAccessTokenModel tokenModel = oAuthApi.getAccessToken(this.clientDataProvider.getClientId(), this.clientDataProvider.getClientSecret(), cloudConfig.getClient(), cloudConfig.getUserId(), cloudConfig.getPassword());
            log.debug("XTM REST Token for has been fetched");
            this.addToken(tokenModel, cloudConfig);
            return true;
        }
        catch (ApiException e) {
            log.error(MSG_API_EXCEPTION, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean refreshToken(TranslationCloudConfig cloudConfig) {
        if (!TranslationCloudConfigUtil.isValid(cloudConfig)) {
            log.warn(MSG_INVALID_XTM_CC);
            return false;
        }
        try {
            OauthAccessTokenModel token = this.tokenStore.getTokenResponse(cloudConfig);
            ApiClient apiClient = this.clientFactory.create(cloudConfig);
            OauthApi oAuthApi = new OauthApi(apiClient);
            if (this.shouldRefreshToken(token)) {
                OauthAccessTokenModel tokenModel = oAuthApi.refreshAccessToken(this.clientDataProvider.getClientId(), this.clientDataProvider.getClientSecret(), token.getAccessToken());
                log.debug("XTM REST Token has been refreshed");
                this.addToken(tokenModel, cloudConfig);
                return true;
            }
        }
        catch (ApiException e) {
            log.error(MSG_API_EXCEPTION, (Throwable)e);
        }
        return false;
    }

    private void addToken(OauthAccessTokenModel tokenModel, TranslationCloudConfig cloudConfig) {
        if (tokenModel != null) {
            log.debug("XTM REST Token has been refreshed: {}", (Object)tokenModel);
            this.tokenStore.addToken(cloudConfig, tokenModel);
        }
    }

    private boolean shouldRefreshToken(OauthAccessTokenModel token) {
        return token != null && token.getRefreshToken() != null && token.isExpired();
    }
}

