/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services;

import com.adobe.granite.license.ProductInfoProvider;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.SystemInfoProvider;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmSystemInfoProvider
implements SystemInfoProvider {
    private static final String UNKNOWN = "Unknown";
    @Reference
    private ProductInfoProvider productInfoProvider;
    private String aemVersion;
    private String xtmConnectVersion;

    @Activate
    public void activate(BundleContext bundleContext) {
        this.aemVersion = Optional.of(this.productInfoProvider).map(ProductInfoProvider::getProductInfo).map(productInfo -> productInfo.getName() + " " + productInfo.getVersion()).orElse(UNKNOWN);
        this.xtmConnectVersion = Optional.of(bundleContext).map(BundleContext::getBundle).map(Bundle::getVersion).map(v -> v.getMajor() + "." + v.getMinor() + "." + v.getMicro() + " " + StringUtils.replace((String)v.getQualifier(), (String)"_", (String)".")).orElse(UNKNOWN);
    }

    @Override
    public String getAemVersion() {
        return this.aemVersion;
    }

    @Override
    public String getXtmConnectVersion() {
        return this.xtmConnectVersion;
    }
}

