/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.config;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.http.ProxyConfigurationOverride;
import com.xtm.aem.api.config.http.ProxyConfigurationProvider;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"service.description=Proxy settings for the XTM Connect - AEM", "label=XTM Connect - AEM - Connector Proxy"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class ProxyConfigurationProviderService
implements ProxyConfigurationProvider {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ProxyConfigurationOverride xtmOverride;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<ProxyConfiguration> proxyConfigurations = new CopyOnWriteArrayList<ProxyConfiguration>();

    @Override
    public ProxyConfiguration getProxyConfiguration(String xtmAddress) {
        if (this.xtmOverride != null) {
            return this.xtmOverride.isForceNoProxy() ? null : this.xtmOverride;
        }
        for (ProxyConfiguration config : this.proxyConfigurations) {
            if (!config.isEnabled() || StringUtils.isBlank((CharSequence)config.getHostname()) || config.getPort() <= 0 || !Arrays.stream(config.getProxyExceptions()).noneMatch(xtmAddress::contains)) continue;
            return config;
        }
        return null;
    }
}

