/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.config;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.TranslationCloudConfigFinder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.adapter.Adaption;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(reference={@Reference(name="$$scr$$ignore0", service=AuthorInstance.class), @Reference(name="$$scr$$ignore1", service=Adaption.class, target="(&(adaptables=org.apache.sling.api.resource.Resource)(adapters=com.xtm.aem.api.config.TranslationCloudConfig))")})
public class TranslationCloudConfigFinderService
implements TranslationCloudConfigFinder {
    private static final String CC_SUB_PATH = "/settings/cloudconfigs/translation";
    private static final String FIND_XTM_CONFIGURATION = "SELECT * FROM [nt:base] AS r WHERE ISDESCENDANTNODE([%s]) AND r.[jcr:content/sling:resourceType] = 'cq/translation/components/mt-cloudconfig'AND r.[jcr:content/cq:template] = '/apps/xtm/templates/xtm-connector-servicepage'";

    @Override
    public TranslationCloudConfig getConfig(String configFolderPath, ResourceResolver resourceResolver) {
        TranslationCloudConfig folderConfig = this.getConfigInternal(configFolderPath + CC_SUB_PATH, resourceResolver);
        return folderConfig != null ? folderConfig : this.getConfigInternal("/conf/global/settings/cloudconfigs/translation", resourceResolver);
    }

    @Override
    public Collection<TranslationCloudConfig> getConfigs(ResourceResolver resourceResolver) {
        Iterator<Resource> configs = this.findConfigs("/conf", resourceResolver);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(configs, 16), false).map(resource -> (TranslationCloudConfig)resource.adaptTo(TranslationCloudConfig.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private TranslationCloudConfig getConfigInternal(String configFolderPath, ResourceResolver resourceResolver) {
        Iterator<Resource> foundConfigResources = this.findConfigs(configFolderPath, resourceResolver);
        if (!foundConfigResources.hasNext()) {
            return null;
        }
        Resource configResource = foundConfigResources.next();
        if (foundConfigResources.hasNext()) {
            throw new IllegalArgumentException("Found multiple XTM Connect - AEM configurations under path '" + configFolderPath + "'");
        }
        return (TranslationCloudConfig)configResource.adaptTo(TranslationCloudConfig.class);
    }

    private Iterator<Resource> findConfigs(String configFolderPath, ResourceResolver resourceResolver) {
        String query = String.format(FIND_XTM_CONFIGURATION, configFolderPath);
        return resourceResolver.findResources(query, "JCR-SQL2");
    }
}

