/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.config;

import com.xtm.aem.api.config.http.ConduitConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ConduitConfiguration.class}, property={"service.description=HTTP Conduit settings for the XTM Connect - AEM", "label=XTM Connect - AEM - Connector HTTP Conduit Configuration"})
@Designate(ocd=Configuration.class)
public class XtmConduitConfiguration
implements ConduitConfiguration {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private static final int DEFAULT_RECEIVE_TIMEOUT = 60000;
    private int connectionTimeout;
    private int receiveTimeout;

    @Activate
    public void activate(Configuration configuration) {
        this.connectionTimeout = configuration.connection_timeout() > 0 ? configuration.connection_timeout() : 30000;
        this.receiveTimeout = configuration.receive_timeout() > 0 ? configuration.receive_timeout() : 60000;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @ObjectClassDefinition(name="XTM Translation Connect - AEM - HTTP Conduit", description="XTM Connect - AEM - Connector HTTP Conduit Configuration")
    public static @interface Configuration {
        @AttributeDefinition(name="Connection timeout [ms]", description="The timeout for connection establishment in milliseconds", defaultValue={"30000"})
        public int connection_timeout();

        @AttributeDefinition(name="Receive timeout [ms]", description="The timeout for data receiving in milliseconds", defaultValue={"60000"})
        public int receive_timeout();
    }
}

