/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.healthchecks;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestConnectionStatus;
import com.xtm.aem.api.rest.RestConnectionStatusService;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.models.config.TranslationCloudConfigUtil;
import java.util.Iterator;
import java.util.Objects;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
@HealthCheckService(name="XTM REST API Connection", tags={"xtm", "translation"})
public class XtmRestApiConnectionHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(XtmRestApiConnectionHealthCheck.class);
    private static final String FIND_XTM_CLOUD_CONFIGURATIONS = "SELECT * FROM [nt:base] AS r WHERE ISDESCENDANTNODE([/conf]) AND r.[sling:resourceType] = 'cq/translation/components/mt-cloudconfig'AND r.[cq:template] = '/apps/xtm/templates/xtm-connector-servicepage'";
    private static final String MSG_INVALID_CC = "Provided cloud configuration seems to be invalid '{}'. Please ensure that configuration is set up properly.";
    private static final String MSG_FAILED_TO_ADAPT = "Failed to adapt resource {} to cloud configuration";
    public static final String MSG_CONNECTION_TEST_OK = "XTM Connection test OK: {}";
    public static final String MSG_TEST_CONNECTION_FAILED = "XTM Connection test FAILED: {}";
    @Reference
    private ResourceResolverProvider provider;
    @Reference
    private RestConnectionStatusService restConnectionStatusService;

    public Result execute() {
        FormattingResultLog result = new FormattingResultLog();
        try (ResourceResolver resourceResolver = this.provider.getXtmResourceResolver();){
            Iterator iterator = resourceResolver.findResources(FIND_XTM_CLOUD_CONFIGURATIONS, "JCR-SQL2");
            while (iterator.hasNext()) {
                this.checkConfiguration(Objects.requireNonNull(((Resource)iterator.next()).getParent()), result);
            }
        }
        catch (LoginException e) {
            log.error("Failed to obtain resource resolver", (Throwable)e);
        }
        return new Result((ResultLog)result);
    }

    private void checkConfiguration(Resource cloudConfigurationResource, FormattingResultLog result) {
        log.info("Checking XTM connection for '{}' configuration", (Object)cloudConfigurationResource.getPath());
        TranslationCloudConfig cloudConfig = (TranslationCloudConfig)cloudConfigurationResource.adaptTo(TranslationCloudConfig.class);
        if (cloudConfig == null) {
            log.warn(MSG_FAILED_TO_ADAPT, (Object)cloudConfigurationResource.getPath());
            result.warn(MSG_FAILED_TO_ADAPT, new Object[]{cloudConfigurationResource.getPath()});
            return;
        }
        if (!TranslationCloudConfigUtil.isValid(cloudConfig)) {
            log.warn(MSG_INVALID_CC, (Object)cloudConfig.getPath());
            result.warn(MSG_INVALID_CC, new Object[]{cloudConfig.getPath()});
            return;
        }
        RestConnectionStatus connectionStatus = this.restConnectionStatusService.getConnectionStatus(cloudConfig);
        if (connectionStatus.isConnected()) {
            log.info(MSG_CONNECTION_TEST_OK, (Object)cloudConfig.getPath());
            result.info(MSG_CONNECTION_TEST_OK, new Object[]{cloudConfig.getPath()});
        } else {
            log.warn(MSG_TEST_CONNECTION_FAILED, (Object)cloudConfig.getPath());
            result.warn(MSG_TEST_CONNECTION_FAILED, new Object[]{cloudConfig.getPath()});
        }
    }
}

