/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGEDEFINITIONS;
import com.xtm.aem.rest.openapi.model.RSJobStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectStatusResponse;
import com.xtm.translation.connector.xtmforaem.core.impl.TranslationController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmCancellerService
implements XtmCanceller {
    private static final Logger log = LoggerFactory.getLogger(XtmCancellerService.class);
    @Reference
    private RestActionFactory restActionFactory;

    @Override
    public void cancel(AemTranslationProject project) throws TranslationException {
        log.info("Cancelling project '{}'", (Object)project.getPath());
        this.cancelProjects(Arrays.asList(project.getXtmProjectIds()), project.getConfig());
    }

    @Override
    public void cancel(AemTranslationJob job) throws TranslationException {
        log.info("Cancelling job '{}'", (Object)job.getAemJobId());
        AemTranslationProject project = job.getProject();
        TranslationCloudConfig config = project.getConfig();
        Long xtmProjectId = job.getXtmProjectId();
        if (this.isOnlyAemJobWithinXtmProject(job, project)) {
            this.cancelProject(xtmProjectId, config);
        }
        List<Long> xtmJobIdsToDelete = job.getAemTranslationObjects().stream().map(AemTranslationObject::getXtmJobId).collect(Collectors.toList());
        CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguage = TranslationController.getTargetLanguageCodeEnum(job);
        this.deleteJobsFromXtmProject(config, xtmProjectId, xtmJobIdsToDelete, targetLanguage);
    }

    @Override
    public void cancel(AemTranslationObject translationObject) throws TranslationException {
        log.info("Cancelling translation object '{}'", (Object)translationObject.getAemTranslationObjectId());
        AemTranslationProject project = translationObject.getProject();
        AemTranslationJob job = translationObject.getJob();
        TranslationCloudConfig config = project.getConfig();
        Long xtmProjectId = job.getXtmProjectId();
        if (job.getAemTranslationObjects().size() == 1 && this.isOnlyAemJobWithinXtmProject(job, project)) {
            this.cancelProject(xtmProjectId, config);
            return;
        }
        List<Long> xtmJobIdsToDelete = Collections.singletonList(translationObject.getXtmJobId());
        CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguage = TranslationController.getTargetLanguageCodeEnum(job);
        this.deleteJobsFromXtmProject(config, xtmProjectId, xtmJobIdsToDelete, targetLanguage);
    }

    private void cancelProject(Long projectId, TranslationCloudConfig config) throws TranslationException {
        this.cancelProjects(Collections.singletonList(projectId), config);
    }

    private void cancelProjects(Collection<Long> projectIds, TranslationCloudConfig config) throws TranslationException {
        this.restActionFactory.getCancelProjectAction(projectIds, config).run();
    }

    private void deleteJobsFromXtmProject(TranslationCloudConfig config, Long xtmProjectId, List<Long> xtmJobIds, CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum targetLanguage) throws TranslationException {
        RSProjectStatusResponse projectStatus = this.restActionFactory.getCheckProjectCompletionAction(xtmProjectId, config).run();
        List<String> fileNames = Objects.requireNonNull(projectStatus.getJobs()).stream().filter(xtmJob -> targetLanguage.getValue().equals(xtmJob.getTargetLanguage())).filter(xtmJob -> xtmJobIds.contains(xtmJob.getJobId())).map(RSJobStatusResponse::getFileName).collect(Collectors.toList());
        this.restActionFactory.getDeleteTranslationFilesAction(xtmProjectId, Collections.singletonList(targetLanguage), fileNames, config).run();
    }

    private boolean isOnlyAemJobWithinXtmProject(AemTranslationJob job, AemTranslationProject project) {
        return project.getTranslationJobs().stream().map(AemTranslationJob::getXtmProjectId).filter(job.getXtmProjectId()::equals).count() == 1L;
    }
}

