/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.google.common.collect.Lists;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.preview.PreviewConfig;
import com.xtm.aem.api.services.preview.PreviewConfigReplacementItem;
import com.xtm.aem.services.translation.preview.XtmPreviewConfigReplacementItem;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.ObjectUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PreviewConfig.class}, property={"service.description=Define additional configurations for XTM preview here", "label=XTM Preview configuration"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
@Designate(ocd=Configuration.class)
public class XtmPreviewConfig
implements PreviewConfig {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewConfig.class);
    private final List<Pattern> referenceFilters = Lists.newArrayList();
    private final List<Pattern> customHtmlReferencePatterns = Lists.newArrayList();
    private final List<PreviewConfigReplacementItem> replacements = Lists.newArrayList();

    @Activate
    public void activate(Configuration configuration) {
        this.setupPatterns(configuration.reference_filters(), this.referenceFilters, "reference filters");
        this.setupPatterns(configuration.custom_html_reference_patterns(), this.customHtmlReferencePatterns, "custom HTML references patterns");
        String[] replacementMatchPatterns = (String[])ObjectUtils.defaultIfNull((Object)configuration.replacement_match_patterns(), (Object)new String[0]);
        String[] replacementStrings = (String[])ObjectUtils.defaultIfNull((Object)configuration.replacement_strings(), (Object)new String[0]);
        if (replacementStrings.length != replacementMatchPatterns.length) {
            log.warn("Invalid configuration of content replacement feature. Please ensure that count of 'Replacement Match Patterns' is equal to count of 'Replacement Strings'");
            return;
        }
        for (int i = 0; i < replacementMatchPatterns.length; ++i) {
            String regexString = replacementMatchPatterns[i];
            try {
                XtmPreviewConfigReplacementItem item = new XtmPreviewConfigReplacementItem(Pattern.compile(regexString), replacementStrings[i]);
                this.replacements.add(item);
                continue;
            }
            catch (PatternSyntaxException e) {
                log.warn("Invalid pattern provided: '{}'", (Object)regexString, (Object)e);
            }
        }
    }

    private void setupPatterns(String[] inputList, List<Pattern> targetList, String name) {
        String[] referencesFiltersStrings;
        for (String regexString : referencesFiltersStrings = (String[])ObjectUtils.defaultIfNull((Object)inputList, (Object)new String[0])) {
            try {
                Pattern pattern = Pattern.compile(regexString);
                targetList.add(pattern);
                if (!log.isDebugEnabled()) continue;
                log.debug("Registering new '{}' pattern: '{}'", (Object)name, (Object)regexString);
            }
            catch (PatternSyntaxException e) {
                log.warn("Invalid pattern provided: '{}'", (Object)regexString, (Object)e);
            }
        }
    }

    @Override
    public List<Pattern> getReferenceFilters() {
        return this.referenceFilters;
    }

    @Override
    public List<Pattern> getCustomHtmlReferencePatterns() {
        return this.customHtmlReferencePatterns;
    }

    @Override
    public List<PreviewConfigReplacementItem> getReplacements() {
        return this.replacements;
    }

    @ObjectClassDefinition(name="XTM Preview Configuration", description="Define additional configurations for XTM preview here.")
    public static @interface Configuration {
        @AttributeDefinition(name="Replacement Match Patterns", description="Enter replacement match pattern (valid regular expressions) to change the content in the fetched preview file.")
        public String[] replacement_match_patterns() default {};

        @AttributeDefinition(name="Replacement Strings", description="Enter replacement string to change the content in the fetched preview file with this value. Regular expression groups are allowed.")
        public String[] replacement_strings() default {};

        @AttributeDefinition(name="Reference filters", description="Enter reference filters (valid regular expressions) to filter out unwanted references to files that relate to the page for which a preview is to be generated.")
        public String[] reference_filters();

        @AttributeDefinition(name="Custom HTML reference patterns", description="Enter additional, non-standard reference patterns (valid regular expressions) that should be included in the preview package.")
        public String[] custom_html_reference_patterns();
    }
}

