/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.services.preview.PreviewGenerator;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=cq:Page", "sling.servlet.selectors=xtmpreview", "sling.servlet.extensions=zip"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmPreviewServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewServlet.class);
    @Reference
    private PreviewGenerator previewGenerator;
    @Reference
    private ResourceResolverProvider resolverProvider;

    protected void doGet(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String requestedPath = request.getResource().getPath();
        try (ResourceResolver previewResourceResolver = this.resolverProvider.getTranslationPreviewResourceResolver();){
            PageManager pageManager = Objects.requireNonNull((PageManager)previewResourceResolver.adaptTo(PageManager.class));
            Page page = pageManager.getContainingPage(requestedPath);
            if (page == null) {
                response.sendError(404, "Could not find the requested page");
                return;
            }
            byte[] preview = this.previewGenerator.getPreview(page.getPath(), previewResourceResolver).getBytes();
            response.setContentType("application/zip");
            response.setHeader("Content-disposition", "filename=\"" + page.getTitle() + ".zip\"");
            IOUtils.write((byte[])preview, (OutputStream)response.getOutputStream());
        }
        catch (LoginException e) {
            log.error("Could not generate preview for page '{}'", (Object)requestedPath, (Object)e);
            response.sendError(500, "Could not generate preview - see logs for more details");
        }
    }
}

