/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.items;

import com.xtm.aem.api.services.preview.PreviewConfig;
import com.xtm.aem.api.services.preview.PreviewConfigReplacementItem;
import com.xtm.aem.api.services.preview.PreviewItem;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasePreviewItem
implements PreviewItem {
    private static final Logger log = LoggerFactory.getLogger(BasePreviewItem.class);
    protected final String path;
    protected final ByteArrayOutputStream baos;
    protected final String characterEncoding;
    protected final String rawContent;
    protected final PreviewConfig previewConfig;

    protected BasePreviewItem(String path, @NotNull ByteArrayOutputStream baos, String characterEncoding, PreviewConfig previewConfig) {
        this.path = path;
        this.characterEncoding = characterEncoding;
        this.previewConfig = previewConfig;
        this.rawContent = this.getRawContent(path, baos);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.rawContent.getBytes(characterEncoding));
        }
        catch (Exception e) {
            log.error("Failed to write preview content to stream");
        }
        this.baos = byteArrayOutputStream;
    }

    private String getRawContent(String path, ByteArrayOutputStream baos) {
        if (StringUtils.isBlank((CharSequence)this.characterEncoding)) {
            return "";
        }
        try {
            return this.getContentWithReplacedPatterns(baos.toString(this.characterEncoding));
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not get item '{}' as string", (Object)path, (Object)e);
            return "";
        }
    }

    private String getContentWithReplacedPatterns(String content) {
        if (content != null) {
            for (PreviewConfigReplacementItem item : this.previewConfig.getReplacements()) {
                content = content.replaceAll(item.getPattern().pattern(), item.getReplacement());
            }
        }
        return content;
    }

    @Override
    public String getContent() {
        return this.rawContent;
    }

    @Override
    public byte[] getBytes() {
        return this.baos.toByteArray();
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

