/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.items;

import com.xtm.aem.api.services.preview.PreviewConfig;
import com.xtm.aem.services.translation.preview.items.BasePreviewItem;
import com.xtm.aem.services.translation.preview.items.CssPreviewItem;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlPreviewItem
extends BasePreviewItem {
    private static final Logger log = LoggerFactory.getLogger(HtmlPreviewItem.class);
    private static final Pattern htmlRefPattern = Pattern.compile("=\"((/([^ ]*?))(\\.[^ ]*))(?<!\\.html)(\")");
    private String htmlContent;
    private Collection<String> references;

    public HtmlPreviewItem(String path, ByteArrayOutputStream baos, String characterEncoding, PreviewConfig previewConfig) {
        super(path, baos, characterEncoding, previewConfig);
    }

    @Override
    public String getContent() {
        if (this.htmlContent == null) {
            this.htmlContent = this.rawContent;
            this.htmlContent = this.getContentWithReplacedRefs();
        }
        return this.htmlContent;
    }

    private String getContentWithReplacedRefs() {
        String contentWithReplacedRefs = this.htmlContent;
        int level = this.getPath().split("/").length - 2;
        String prefix = String.join((CharSequence)"/", Collections.nCopies(level, ".."));
        for (String refPath : this.getReferences()) {
            contentWithReplacedRefs = StringUtils.replace((String)contentWithReplacedRefs, (String)refPath, (String)(prefix + refPath));
        }
        return contentWithReplacedRefs;
    }

    @Override
    public Collection<String> getReferences() {
        if (this.references == null) {
            this.references = new HashSet<String>();
            this.extractHtmlRefs(this.references);
            this.extractInlineStyleRefs(this.references);
            this.extractCustomPatternsRefs(this.references);
        }
        return this.references;
    }

    private void extractCustomPatternsRefs(Collection<String> references) {
        this.previewConfig.getCustomHtmlReferencePatterns().forEach(pattern -> {
            log.trace("Extracting custom pattern from HTML '{}'", (Object)pattern.toString());
            Matcher matcher = pattern.matcher(this.rawContent);
            while (matcher.find()) {
                String group = matcher.group();
                if (!StringUtils.isNotBlank((CharSequence)group)) continue;
                log.trace("Adding custom pattern match '{}'", (Object)group);
                references.add(group);
            }
        });
    }

    private void extractHtmlRefs(Collection<String> refs) {
        Matcher matcher = htmlRefPattern.matcher(this.rawContent);
        while (matcher.find()) {
            String[] parts;
            String extension;
            String newMatch = matcher.group(1);
            if (!newMatch.contains(".") || StringUtils.startsWith((CharSequence)newMatch, (CharSequence)"//") || "html".equals(extension = (parts = (newMatch = StringUtils.substringBefore((String)newMatch, (String)"?")).split("\\."))[parts.length - 1]) || "pdf".equals(extension)) continue;
            refs.add(newMatch);
        }
    }

    private void extractInlineStyleRefs(Collection<String> references) {
        CssPreviewItem cssPreviewItem = new CssPreviewItem(this.path, this.baos, this.characterEncoding, this.previewConfig);
        references.addAll(cssPreviewItem.getReferences());
    }
}

