/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.standalone;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xtm.aem.api.services.preview.standalone.AccessToken;
import java.util.Calendar;
import java.util.Date;

public class XtmPreviewAccessToken
implements AccessToken {
    private final String accessToken;
    private final Date createdAt;
    private final Date expiresAt;

    @JsonCreator
    public XtmPreviewAccessToken(@JsonProperty(value="accessToken") String accessToken, @JsonProperty(value="expiresIn") int expiresIn) {
        this.accessToken = accessToken;
        this.createdAt = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.createdAt);
        calendar.add(13, expiresIn);
        this.expiresAt = calendar.getTime();
    }

    @Override
    public boolean isExpired() {
        return this.expiresAt.compareTo(new Date()) <= 0;
    }

    public String toString() {
        return "XtmPreviewAccessToken{accessToken='" + this.accessToken + '\'' + ", createdAt=" + this.createdAt + ", expiresAt=" + this.expiresAt + '}';
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getExpiresAt() {
        return this.expiresAt;
    }
}

