/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.standalone;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.services.preview.standalone.AccessToken;
import com.xtm.aem.api.services.preview.standalone.PreviewGenerationServiceClient;
import com.xtm.aem.api.services.preview.standalone.PreviewGenerationServiceException;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.services.translation.preview.standalone.AuthLoginRequestEntity;
import com.xtm.aem.services.translation.preview.standalone.PreviewRequestEntity;
import com.xtm.aem.services.translation.preview.standalone.PreviewRequestEntityItem;
import com.xtm.aem.services.translation.preview.standalone.XtmPreviewAccessToken;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmPreviewGenerationServiceClient
implements PreviewGenerationServiceClient {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewGenerationServiceClient.class);
    private static final String API_AUTH_PATH = "/api/auth/login";
    private static final String API_PREVIEW_PATH = "/api/preview";
    public static final String MSG_FAILED_TO_EXECUTE_HTTP_REQUEST = "Failed to execute HTTP request, ";
    public static final String MSG_FAILED_TO_CREATE_HTTP_CLIENT = "Failed to create HTTP client";
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public AccessToken authLogin(TranslationCloudConfig cloudConfig) throws PreviewGenerationServiceException {
        try (CloseableHttpClient httpClient = this.httpClientBuilderFactory.newBuilder().build();){
            AccessToken accessToken;
            block18: {
                String uri = cloudConfig.getPreviewGenerationServiceUrl() + API_AUTH_PATH;
                RequestBuilder builder = RequestBuilder.create((String)"POST");
                AuthLoginRequestEntity requestEntity = new AuthLoginRequestEntity(cloudConfig.getClient(), cloudConfig.getUserId(), cloudConfig.getPassword());
                ObjectMapper mapper = new ObjectMapper();
                String requestEntityString = mapper.writeValueAsString((Object)requestEntity);
                StringEntity entity = new StringEntity(requestEntityString, ContentType.APPLICATION_JSON);
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                builder.setEntity((HttpEntity)entity);
                builder.setUri(uri);
                CloseableHttpResponse response = httpClient.execute(builder.build());
                try {
                    int httpStatus = response.getStatusLine().getStatusCode();
                    if (httpStatus != 200) {
                        String msg = "Failed to login, status: %s, cause: %s";
                        msg = String.format(msg, httpStatus, EntityUtils.toString((HttpEntity)response.getEntity()));
                        throw new PreviewGenerationServiceException(msg);
                    }
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    accessToken = (AccessToken)mapper.readValue(json, XtmPreviewAccessToken.class);
                    if (response == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new PreviewGenerationServiceException(MSG_FAILED_TO_EXECUTE_HTTP_REQUEST + uri, e);
                    }
                }
                response.close();
            }
            return accessToken;
        }
        catch (IOException e) {
            throw new PreviewGenerationServiceException(MSG_FAILED_TO_CREATE_HTTP_CLIENT, e);
        }
    }

    @Override
    public void requestPreview(String authToken, AemTranslationJob aemTranslationJob) throws PreviewGenerationServiceException {
        TranslationCloudConfig config = aemTranslationJob.getProject().getConfig();
        PreviewRequestEntity previewRequest = this.getPreviewRequestEntity(aemTranslationJob, config);
        String uri = config.getPreviewGenerationServiceUrl() + API_PREVIEW_PATH;
        if (previewRequest.getItems().isEmpty()) {
            log.info("No items for preview generation found");
            return;
        }
        try (CloseableHttpClient build = this.httpClientBuilderFactory.newBuilder().build();){
            RequestBuilder builder = RequestBuilder.create((String)"POST");
            String json = new ObjectMapper().writeValueAsString((Object)previewRequest);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            builder.setEntity((HttpEntity)entity);
            builder.setUri(uri);
            builder.setHeader("Authorization", "Bearer " + authToken);
            try (CloseableHttpResponse response = build.execute(builder.build());){
                int httpStatus = response.getStatusLine().getStatusCode();
                if (httpStatus != 200) {
                    String msg = "Failed to request preview: %s, cause: %s";
                    msg = String.format(msg, httpStatus, EntityUtils.toString((HttpEntity)response.getEntity()));
                    throw new PreviewGenerationServiceException(msg);
                }
                log.info(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (IOException e) {
                throw new PreviewGenerationServiceException(MSG_FAILED_TO_EXECUTE_HTTP_REQUEST + uri, e);
            }
        }
        catch (IOException e) {
            throw new PreviewGenerationServiceException(MSG_FAILED_TO_CREATE_HTTP_CLIENT, e);
        }
    }

    @NotNull
    private PreviewRequestEntity getPreviewRequestEntity(AemTranslationJob aemTranslationJob, TranslationCloudConfig config) throws PreviewGenerationServiceException {
        PreviewRequestEntity previewRequest = new PreviewRequestEntity();
        String urlTemplate = config.getPreviewGenerationSourceUrlTemplate();
        if (StringUtils.isBlank((CharSequence)urlTemplate)) {
            throw new PreviewGenerationServiceException("'Preview Generation Source URL Template' value is is empty");
        }
        if (!StringUtils.contains((CharSequence)urlTemplate, (CharSequence)"$PATH")) {
            throw new PreviewGenerationServiceException("'Preview Generation Source URL Template' does not contain '$PATH'");
        }
        previewRequest.setCustomScript(config.getPreviewGenerationCustomScript());
        previewRequest.setToRemoveSelectors(config.getPreviewGenerationToRemoveSelectors());
        previewRequest.setProjectId(aemTranslationJob.getXtmProjectId());
        aemTranslationJob.getAemTranslationObjects().stream().filter(this::shouldGetPreview).map(ato -> this.getLink((AemTranslationObject)ato, urlTemplate)).forEach(item -> previewRequest.getItems().add((PreviewRequestEntityItem)item));
        return previewRequest;
    }

    private boolean shouldGetPreview(AemTranslationObject ato) {
        return ato.getRawPage() != null && ato.getRawPage().getSourcePath() != null && ato.getRawPage().getSourcePath().startsWith("/content") && !ato.getRawPage().getSourcePath().startsWith("/content/dam");
    }

    private PreviewRequestEntityItem getLink(AemTranslationObject ato, String urlTemplate) {
        String url = urlTemplate.replace("$PATH", ato.getSourcePath());
        String fileName = ato.getFileName().replaceAll(".xml", ".html");
        return new PreviewRequestEntityItem(fileName, url);
    }
}

