/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.standalone;

import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.services.preview.standalone.AccessToken;
import com.xtm.aem.api.services.preview.standalone.PreviewGenerationServiceTokenStore;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmPreviewGenerationServiceTokenStore
implements PreviewGenerationServiceTokenStore {
    private static final Logger log = LoggerFactory.getLogger(XtmPreviewGenerationServiceTokenStore.class);
    private final Map<String, AccessToken> tokenMap = new HashMap<String, AccessToken>();

    @Override
    public void add(TranslationCloudConfig config, AccessToken accessToken) {
        String key = this.getKey(config);
        this.tokenMap.put(this.getKey(config), accessToken);
        log.debug("Entry added, key {}, value {}", (Object)key, (Object)accessToken);
    }

    @Override
    public AccessToken get(TranslationCloudConfig config) {
        String key = this.getKey(config);
        AccessToken entry = this.tokenMap.get(key);
        log.debug("Getting entry, key {}, value {}", (Object)key, (Object)entry);
        return entry;
    }

    private String getKey(TranslationCloudConfig config) {
        return config.getClient() + ":" + config.getUserId();
    }
}

