/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.services.translation.preview.zip;

import com.xtm.aem.api.services.preview.PreviewZipEntry;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.services.translation.preview.models.PreviewZipEntryModel;
import com.xtm.aem.services.translation.preview.models.PreviewZipFileModel;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public final class PreviewZipUtils {
    public static final Function<String, String> STANDARDIZE_SLASHES = PreviewZipUtils::standardizeSlashes;
    public static final Function<String, String> STRIP_LEADING_SLASH = PreviewZipUtils::stripLeadingSlash;

    public static PreviewZipFile aggregate(Collection<PreviewZipFile> zips) {
        PreviewZipFileModel aggregated = new PreviewZipFileModel();
        zips.forEach(aggregated::putAll);
        return aggregated;
    }

    public static PreviewZipFile rename(PreviewZipFile zip, Function<String, String> renamingFunction) {
        PreviewZipFileModel result = new PreviewZipFileModel();
        for (PreviewZipEntry entry : zip.values()) {
            String newName = renamingFunction.apply(entry.getName());
            PreviewZipEntryModel renamedEntry = new PreviewZipEntryModel(newName, entry.getContent());
            result.put(renamedEntry);
        }
        return result;
    }

    public static Function<String, String> getNameMappingFunction(Map<String, String> nameMapping) {
        return key -> nameMapping.getOrDefault(key, (String)key);
    }

    private static String standardizeSlashes(String path) {
        return path.replace('\\', '/');
    }

    private static String stripLeadingSlash(String path) {
        return path.charAt(0) == '/' ? path.substring(1) : path;
    }
}

