/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.soap.legacy;

import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.soap.legacy.AbstractXtmServiceSoapAction;
import com.xtm.aem.soap.legacy.impl.XtmServiceAction;
import com.xtm.aem.soap.wsdl.LoginAPI;
import com.xtm.aem.soap.wsdl.XtmCheckJobCompletionResponseAPI;
import com.xtm.aem.soap.wsdl.XtmDownloadJobMTOMOptionsAPI;
import com.xtm.aem.soap.wsdl.XtmDownloadJobMTOMResponseAPI;
import com.xtm.aem.soap.wsdl.XtmDownloadProjectMTOMResponseAPI;
import com.xtm.aem.soap.wsdl.XtmJOBCOMPLETIONSTATUS;
import com.xtm.aem.soap.wsdl.XtmJobDescriptorAPI;
import com.xtm.aem.soap.wsdl.XtmJobFileMTOMResponseAPI;
import com.xtm.aem.soap.wsdl.XtmObtainJobExtraInfoResponseAPI;
import com.xtm.aem.soap.wsdlextensions.Login;
import com.xtm.aem.soap.wsdlextensions.XtmJobDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class RetrieveTranslationResultAsInputStreamSoapAction
extends AbstractXtmServiceSoapAction<InputStream>
implements XtmServiceAction<InputStream> {
    private final LoginAPI loginAPI;
    private final Long jobId;
    private final List<XtmJobDescriptorAPI> jobDescriptors;
    private final XtmDownloadJobMTOMOptionsAPI jobMTOMOptions;
    private final String originalFileName;
    private final String prefixedFileName;
    private final String targetLanguageCode;

    public RetrieveTranslationResultAsInputStreamSoapAction(Long jobId, String originalFileName, TranslationCloudConfig xtmCloudConfig, String targetLanguageCode) {
        this.cloudConfig = xtmCloudConfig;
        this.loginAPI = new Login(this.cloudConfig);
        this.jobId = jobId;
        this.jobDescriptors = new ArrayList<XtmJobDescriptorAPI>();
        this.jobDescriptors.add(new XtmJobDescriptor(jobId));
        this.jobMTOMOptions = null;
        this.proxyConfiguration = this.cloudConfig.getProxyConfiguration();
        this.originalFileName = originalFileName.charAt(0) == '/' ? originalFileName.substring(1) : originalFileName;
        this.prefixedFileName = targetLanguageCode + '/' + this.originalFileName;
        this.targetLanguageCode = targetLanguageCode;
    }

    @Override
    protected InputStream run() throws Exception {
        XtmDownloadJobMTOMResponseAPI xtmResponse = this.xtmWebService.downloadJobMTOM(this.loginAPI, this.jobDescriptors, this.jobMTOMOptions);
        if (null == xtmResponse || xtmResponse.getJobs().isEmpty()) {
            XtmCheckJobCompletionResponseAPI checkJobCompletion = this.xtmWebService.checkJobCompletion(this.loginAPI, this.jobDescriptors, null);
            if (checkJobCompletion.getJobs().get(0).getStatus() == XtmJOBCOMPLETIONSTATUS.FINISHED) {
                XtmObtainJobExtraInfoResponseAPI jobExtraInfo = this.xtmWebService.obtainJobExtraInfo(this.loginAPI, this.jobDescriptors, null);
                XtmDownloadProjectMTOMResponseAPI response = this.xtmWebService.downloadProjectMTOM(this.loginAPI, jobExtraInfo.getJobs().get(0).getProjectDescriptor(), null);
                Set jobIds = this.jobDescriptors.stream().map(XtmJobDescriptorAPI::getId).collect(Collectors.toSet());
                List fileMTOMResponseAPIList = response.getProject().getJobs().stream().filter(jobDescriptor -> jobIds.contains(jobDescriptor.getJobDescriptor().getId())).collect(Collectors.toList());
                XtmJobFileMTOMResponseAPI jobFile = (XtmJobFileMTOMResponseAPI)fileMTOMResponseAPIList.get(0);
                if (jobFile.getFileMTOM().length > 0) {
                    try {
                        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(jobFile.getFileMTOM()));
                        ZipEntry entry = zis.getNextEntry();
                        while (entry != null) {
                            if (this.entryHasMatchingName(entry)) {
                                return zis;
                            }
                            entry = zis.getNextEntry();
                        }
                    }
                    catch (IOException e) {
                        throw new XtmConnectorException("Error while reading result file from XTM.");
                    }
                    throw new XtmConnectorException("XTM response did not contain file for job '" + this.jobId + "'");
                }
                throw new XtmConnectorException("Translation result file from XTM is empty");
            }
            throw new XtmConnectorException("Empty response received from XTM service while retrieving translation result file.");
        }
        XtmJobFileMTOMResponseAPI jobFile = xtmResponse.getJobs().get(0);
        if (jobFile.getFileMTOM().length > 0) {
            try {
                ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(jobFile.getFileMTOM()));
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    if (this.entryHasMatchingName(entry)) {
                        return zis;
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new XtmConnectorException("Error while reading result file from XTM.");
            }
            throw new XtmConnectorException("XTM response did not contain file for job '" + this.jobId + "'");
        }
        throw new XtmConnectorException("Translation result file from XTM is empty");
    }

    private boolean entryHasMatchingName(ZipEntry entry) {
        String rawEntryName = entry.getName();
        String entryName = rawEntryName.charAt(0) == '/' ? rawEntryName.substring(1) : rawEntryName;
        entryName = StringUtils.replace((String)entryName, (String)("_" + this.targetLanguageCode), (String)"");
        return StringUtils.equals((CharSequence)this.prefixedFileName, (CharSequence)entryName) || StringUtils.equals((CharSequence)this.originalFileName, (CharSequence)entryName);
    }
}

