/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationException;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.raw.RawTranslationProject;
import com.xtm.aem.api.rest.DueDatesJobModel;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.shared.ResourceResolverProvider;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationProject;
import com.xtm.translation.connector.xtmforaem.core.impl.XtmDueDatesJobModel;
import com.xtm.translation.connector.xtmforaem.core.models.ComplexAemTranslationProjectManager;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"resource.paths=/content/projects", "resource.change.types=CHANGED", "resource.property.names.hint=project.dueDate"}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class ProjectDueDateListener
implements ResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectDueDateListener.class);
    @Reference
    private ResourceResolverProvider provider;
    @Reference
    private RestActionFactory restActionFactory;

    public void onChange(List<ResourceChange> changes) {
        try (ResourceResolver resourceResolver = this.provider.getXtmResourceResolver();){
            for (ResourceChange change : changes) {
                AemTranslationProject atp;
                Resource resource = resourceResolver.getResource(change.getPath());
                if (!this.canRun(resource) || (atp = ComplexAemTranslationProjectManager.getExisting(resourceResolver, resource.getParent().getPath())) == null || !this.isXtmProjectCreated(atp)) continue;
                this.handleProjectDueDateChange(atp);
            }
            if (resourceResolver.hasChanges()) {
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            throw new IllegalStateException("Could not obtain resource resolver", e);
        }
        catch (TranslationException | PersistenceException e) {
            log.error("Failed to update project due date", e);
        }
    }

    private void handleProjectDueDateChange(AemTranslationProject atp) throws TranslationException {
        Date projectDueDate = Optional.of(atp).map(AemTranslationProject::getRawProject).map(RawTranslationProject::getProjectDueDate).orElse(null);
        List<DueDatesJobModel> jobs = ProjectDueDateListener.getDueDateChangeableJobs(atp);
        for (Long xtmProjectId : atp.getXtmProjectIds()) {
            log.debug("Updating project due date for path: {}, XTM project ID: {}, project due date: {}", new Object[]{atp.getPath(), xtmProjectId, projectDueDate});
            if (projectDueDate != null) {
                this.restActionFactory.getUpdateDueDatesAction(xtmProjectId, projectDueDate, null, atp.getConfig()).run();
            }
            if (jobs.isEmpty()) continue;
            this.restActionFactory.getUpdateDueDatesAction(xtmProjectId, null, jobs, atp.getConfig()).run();
        }
    }

    private static boolean shouldSetDate(AemTranslationJob atj) {
        return atj.getRawJob().getDueDate() != null;
    }

    @NotNull
    private static List<DueDatesJobModel> getDueDateChangeableJobs(AemTranslationProject atp) {
        return atp.getTranslationJobs().stream().filter(ProjectDueDateListener::shouldSetDate).map(atj -> {
            atj.setDueDate(atj.getRawJob().getDueDate());
            return atj.getAemTranslationObjects().stream().map(ato -> new XtmDueDatesJobModel(ato.getXtmJobId(), atj.getRawJob().getDueDate())).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean canRun(Resource resource) {
        return resource != null && this.isTranslationProjectContent(resource) && this.isXtmProvider(resource) && this.hasDueDate(resource);
    }

    private boolean isTranslationProjectContent(Resource resource) {
        return resource.isResourceType("cq/gui/components/projects/admin/card/projectcontent");
    }

    private boolean hasDueDate(Resource resource) {
        return Optional.ofNullable(resource).map(Resource::getValueMap).map(vm -> vm.containsKey((Object)"project.dueDate")).orElse(false);
    }

    private boolean isXtmProvider(Resource resource) {
        return Optional.ofNullable(resource).map(Resource::getValueMap).map(vm -> (String)vm.get("translationProvider", String.class)).map(s -> s.equals("xtm-connector")).orElse(false);
    }

    private boolean isXtmProjectCreated(AemTranslationProject atp) {
        return ArrayUtils.isNotEmpty((Object[])atp.getXtmProjectIds());
    }
}

