/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.XtmConnectorException;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.raw.RawTranslationJob;
import com.xtm.aem.api.raw.WorkflowOperationError;
import com.xtm.aem.api.rest.DueDatesJobModel;
import com.xtm.aem.api.rest.RestActionFactory;
import com.xtm.aem.api.services.preview.PreviewFactory;
import com.xtm.aem.api.services.preview.PreviewZipFile;
import com.xtm.aem.api.services.translation.XtmCanceller;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGEDEFINITIONS;
import com.xtm.aem.rest.openapi.model.RSProjectCreationResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileUploadResponse;
import com.xtm.aem.rest.openapi.model.RSProjectJob;
import com.xtm.aem.rest.overrides.ProjectFilesApiMatchType;
import com.xtm.aem.soap.wsdl.LanguageCODE;
import com.xtm.aem.soap.wsdl.XtmPROJECTFILESMATCH;
import com.xtm.translation.connector.xtmforaem.core.impl.ProjectStatusUpdater;
import com.xtm.translation.connector.xtmforaem.core.impl.TranslationController;
import com.xtm.translation.connector.xtmforaem.core.impl.XtmDueDatesJobModel;
import com.xtm.translation.connector.xtmforaem.core.models.ComplexAemTranslationObjectCreator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TranslationJobController.class}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class TranslationJobController {
    private static final Logger log = LoggerFactory.getLogger(TranslationJobController.class);
    private static final Map<String, String> jobIdToJobPathCache = new HashMap<String, String>();
    @Reference
    private ComplexAemTranslationObjectCreator atoManager;
    @Reference
    private XtmCanceller canceller;
    @Reference
    private PreviewFactory previewFactory;
    @Reference
    private TranslationController translationController;
    @Reference
    private RestActionFactory restActionFactory;

    public void updateDueDate(AemTranslationJob atj, Date jobDueDate) throws TranslationException {
        if (jobDueDate == null) {
            return;
        }
        atj.getProject().getTranslationJobs().stream().filter(p -> Objects.equals(p.getXtmProjectId(), atj.getXtmProjectId())).forEach(p -> p.setDueDate(jobDueDate));
        List<DueDatesJobModel> jobs = atj.getAemTranslationObjects().stream().map(item -> new XtmDueDatesJobModel(item.getXtmJobId(), jobDueDate)).collect(Collectors.toList());
        this.restActionFactory.getUpdateDueDatesAction(atj.getXtmProjectId(), null, jobs, atj.getProject().getConfig()).run();
    }

    public TranslationConstants.TranslationStatus updateTranslationStatus(AemTranslationJob atj, TranslationConstants.TranslationStatus statusFromAem) throws TranslationException {
        TranslationCloudConfig xtmCloudConfig = atj.getProject().getConfig();
        ProjectStatusUpdater projectStatusUpdater = new ProjectStatusUpdater(xtmCloudConfig, this.restActionFactory, this.canceller);
        TranslationConstants.TranslationStatus statusFromXtm = projectStatusUpdater.updateProjectStatus(statusFromAem, atj);
        atj.setTranslationStatus(statusFromXtm);
        return statusFromXtm;
    }

    public TranslationConstants.TranslationStatus obtainTranslationStatus(AemTranslationJob atj) throws TranslationException {
        TranslationConstants.TranslationStatus currentStatus = atj.getTranslationStatus();
        if (TranslationConstants.TranslationStatus.SCOPE_REQUESTED.equals((Object)currentStatus) || TranslationConstants.TranslationStatus.SCOPE_COMPLETED.equals((Object)currentStatus)) {
            return currentStatus;
        }
        TranslationConstants.TranslationStatus statusFromXtm = this.restActionFactory.getObtainProjectTranslationStatusAction(atj.getXtmProjectId(), atj.getProject().getConfig()).run();
        atj.setTranslationStatus(statusFromXtm);
        return statusFromXtm;
    }

    public AemTranslationObject addAemTranslationObject(AemTranslationJob atj, TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig) throws PersistenceException, TranslationException, XtmConnectorException {
        String i18nWorkaroundId;
        if ((atj.getTargetLanguage() + ".json").equals(translationObject.getTitle()) && atj.hasAemTranslationObject(i18nWorkaroundId = "I18NCOMPONENTSTRINGDICT_" + StringUtils.substringAfterLast((String)atj.getAemJobId(), (String)"_"))) {
            AemTranslationObject existingAto = atj.getAemTranslationObject(i18nWorkaroundId);
            this.restActionFactory.getDeleteTranslationFilesAction(atj.getXtmProjectId(), (Collection<CUSTOMERLANGUAGEDEFINITIONS.LanguageCodeEnum>)ImmutableList.of((Object)((Object)TranslationController.getTargetLanguageCodeEnum(atj))), (Collection<String>)ImmutableList.of((Object)existingAto.getFileName()), atj.getProject().getConfig()).run();
            this.restActionFactory.getProjectAnalysisCompletionAction(atj.getXtmProjectId(), atj.getProject().getConfig()).run();
            existingAto.setTranslationFile(translationObject.getTranslationObjectXMLInputStream());
            this.updateXtmProject(atj, (Map<XtmPROJECTFILESMATCH, List<AemTranslationObject>>)ImmutableMap.of((Object)((Object)XtmPROJECTFILESMATCH.NO_MATCH), (Object)ImmutableList.of((Object)existingAto)));
            return existingAto;
        }
        AemTranslationObject newAto = this.atoManager.create(atj.getResource(), translationObject, xtmCloudConfig);
        String newAtoId = newAto.getAemTranslationObjectId();
        if (atj.hasAemTranslationObject(newAtoId)) {
            throw new IllegalArgumentException("Translation object with id '" + newAtoId + "' already present in translation job '" + atj.getAemJobId() + "'");
        }
        atj.addAemTranslationObject(newAto);
        return newAto;
    }

    public void sendToXtm(AemTranslationJob atj, ResourceResolver resourceResolver) throws TranslationException, IOException, XtmConnectorException {
        TranslationCloudConfig xtmCloudConfig = atj.getProject().getConfig();
        switch (xtmCloudConfig.getProjectCreationStrategy()) {
            case PROJECT_UPDATE: {
                Long activeXtmProjectId = this.translationController.getActiveXtmProjectId(atj);
                if (activeXtmProjectId != null) {
                    atj.setXtmProjectId(activeXtmProjectId);
                    try {
                        this.translationController.ensureLanguageSet(atj.getProject(), atj.getTargetLanguage(), atj.getXtmProjectId());
                        Map<XtmPROJECTFILESMATCH, List<AemTranslationObject>> atoMapping = TranslationJobController.getFilesToSend(atj, atj.getXtmProjectId());
                        this.updateXtmProject(atj, atoMapping);
                    }
                    catch (TranslationException e) {
                        log.warn("Failed to update project '{}'. Ensure that file joining is enabled on XTM template-level.", (Object)atj.getXtmProjectId(), (Object)e);
                        this.createNewXtmProject(atj);
                    }
                    break;
                }
                this.createNewXtmProject(atj);
                break;
            }
            case NEW_PROJECT: {
                this.createNewXtmProject(atj);
            }
        }
        atj.markAsSentToXtm();
        resourceResolver.commit();
        PreviewZipFile previewZip = this.previewFactory.getPreview(atj);
        if (!previewZip.isEmpty()) {
            this.sendPreviewToXtm(atj, previewZip);
        }
    }

    private static Map<XtmPROJECTFILESMATCH, List<AemTranslationObject>> getFilesToSend(AemTranslationJob input, Long xtmProjectId) {
        List filesInXtmProject = input.getProject().getTranslationJobs().stream().filter(AemTranslationJob::isSentToXtm).filter(atj -> xtmProjectId.equals(atj.getXtmProjectId())).filter(atj -> StringUtils.equals((CharSequence)atj.getTargetLanguage(), (CharSequence)input.getTargetLanguage())).map(AemTranslationJob::getAemTranslationObjects).flatMap(Collection::stream).map(AemTranslationObject::getFileName).distinct().collect(Collectors.toList());
        return input.getAemTranslationObjects().stream().collect(Collectors.groupingBy(ato -> TranslationController.getFileMatching(ato, filesInXtmProject)));
    }

    private void updateXtmProject(AemTranslationJob atj, Map<XtmPROJECTFILESMATCH, List<AemTranslationObject>> atoMapping) throws TranslationException, XtmConnectorException {
        List<AemTranslationObject> matchedAtos;
        List<AemTranslationObject> newAtos = atoMapping.get((Object)XtmPROJECTFILESMATCH.NO_MATCH);
        Long projectId = atj.getXtmProjectId();
        TranslationCloudConfig config = atj.getProject().getConfig();
        List jobIds = atj.getAemTranslationObjects().stream().map(AemTranslationObject::getXtmJobId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newAtos)) {
            this.updateNoMatchFiles(atj, newAtos);
            this.restActionFactory.getProjectAnalysisCompletionAction(projectId, config).run();
        }
        if (CollectionUtils.isNotEmpty(matchedAtos = atoMapping.get((Object)XtmPROJECTFILESMATCH.MATCH_NAMES))) {
            this.updateMatchingNameFiles(atj, matchedAtos);
        }
        this.updateDueDate(atj, atj.getDueDate());
    }

    private void updateNoMatchFiles(AemTranslationJob input, List<AemTranslationObject> atos) throws TranslationException, XtmConnectorException {
        LanguageCODE targetLanguageCode = TranslationController.getTargetLanguageCode(input);
        RSProjectFileUploadResponse response = this.restActionFactory.getUploadTranslationFileToProjectAction(input.getXtmProjectId(), atos, ProjectFilesApiMatchType.NO_MATCH, input.getProject().getConfig()).run();
        List currentIds = input.getProject().getTranslationJobs().stream().filter(atj -> this.hasNoWorkflowOperationErrors((AemTranslationJob)atj)).filter(atj -> targetLanguageCode.equals((Object)TranslationController.getTargetLanguageCode(atj))).map(AemTranslationJob::getAemTranslationObjects).flatMap(Collection::stream).map(AemTranslationObject::getXtmJobId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        HashMap xtmJobIds = new HashMap();
        response.getJobs().stream().filter(xtmJob -> Objects.equals(xtmJob.getTargetLanguage(), targetLanguageCode.value())).filter(xjr -> !currentIds.contains(xjr.getJobId())).forEach(xjr -> {
            xtmJobIds.put(xjr.getFileName(), xjr.getJobId());
            xtmJobIds.put(TranslationJobController.removeUnderscoreFromDuplicatedXtmFilenames(xjr.getFileName()), xjr.getJobId());
        });
        Map<String, Long> joinedFilesIdMapping = response.getJobs().stream().filter(job -> "joinedFiles".equals(StringUtils.substringBeforeLast((String)job.getFileName(), (String)"."))).collect(Collectors.toMap(job -> StringUtils.substringAfterLast((String)job.getFileName(), (String)"."), RSProjectJob::getJobId));
        for (AemTranslationObject newAto : atos) {
            Long id = (Long)xtmJobIds.get(newAto.getFileName());
            if (id == 0L) {
                id = joinedFilesIdMapping.getOrDefault(StringUtils.substringAfterLast((String)newAto.getFileName(), (String)"."), 0L);
            }
            newAto.setXtmJobId(id);
        }
    }

    private boolean hasNoWorkflowOperationErrors(AemTranslationJob atj) {
        WorkflowOperationError error = Optional.ofNullable(atj).map(AemTranslationJob::getRawJob).map(RawTranslationJob::getWorkflowOperationError).orElse(null);
        return error == null || WorkflowOperationError.NO_ERROR.equals((Object)error);
    }

    private void updateMatchingNameFiles(AemTranslationJob input, List<AemTranslationObject> atos) throws TranslationException, XtmConnectorException {
        LanguageCODE targetLanguageCode = TranslationController.getTargetLanguageCode(input);
        RSProjectFileUploadResponse response = this.restActionFactory.getUploadTranslationFileToProjectAction(input.getXtmProjectId(), atos, ProjectFilesApiMatchType.MATCH_NAMES, input.getProject().getConfig()).run();
        HashMap xtmJobIds = new HashMap();
        response.getJobs().stream().filter(xtmJob -> Objects.equals(xtmJob.getTargetLanguage(), targetLanguageCode.value())).forEach(xjr -> {
            xtmJobIds.put(xjr.getFileName(), xjr.getJobId());
            xtmJobIds.put(TranslationJobController.removeUnderscoreFromDuplicatedXtmFilenames(xjr.getFileName()), xjr.getJobId());
        });
        Map<String, Long> joinedFilesIdMapping = response.getJobs().stream().filter(job -> "joinedFiles".equals(StringUtils.substringBeforeLast((String)job.getFileName(), (String)"."))).collect(Collectors.toMap(job -> StringUtils.substringAfterLast((String)job.getFileName(), (String)"."), RSProjectJob::getJobId));
        for (AemTranslationObject newAto : atos) {
            Long id = (Long)xtmJobIds.get(newAto.getFileName());
            if (id == 0L) {
                id = joinedFilesIdMapping.getOrDefault(StringUtils.substringAfterLast((String)newAto.getFileName(), (String)"."), 0L);
            }
            newAto.setXtmJobId(id);
        }
    }

    private RSProjectCreationResponse createNewXtmProject(AemTranslationJob atj) throws TranslationException, XtmConnectorException {
        RSProjectCreationResponse response = this.restActionFactory.getCreateProjectAction(atj).run();
        atj.setXtmProjectId(response.getProjectId());
        this.updateAtoIds(atj, response);
        return response;
    }

    private void updateAtoIds(AemTranslationJob input, RSProjectCreationResponse projectResponse) throws XtmConnectorException {
        LanguageCODE targetLanguageCode = TranslationController.getTargetLanguageCode(input);
        HashMap xtmJobIds = new HashMap();
        projectResponse.getJobs().stream().filter(xtmJob -> Objects.equals(xtmJob.getTargetLanguage(), targetLanguageCode.value())).forEach(xjr -> xtmJobIds.put(xjr.getFileName(), xjr.getJobId()));
        projectResponse.getJobs().stream().filter(xtmJob -> Objects.equals(xtmJob.getTargetLanguage(), targetLanguageCode.value())).forEach(xjr -> xtmJobIds.put(TranslationJobController.removeUnderscoreFromDuplicatedXtmFilenames(xjr.getFileName()), xjr.getJobId()));
        Map aemJobIds = input.getProject().getTranslationJobs().stream().filter(this::hasNoWorkflowOperationErrors).filter(atj -> TranslationController.getTargetLanguageCode(atj) == targetLanguageCode).filter(AemTranslationJob::isSentToXtm).filter(atj -> atj.getXtmProjectId().equals(input.getXtmProjectId())).map(AemTranslationJob::getAemTranslationObjects).flatMap(Collection::stream).filter(ato -> StringUtils.isNotBlank((CharSequence)ato.getSourcePath())).collect(Collectors.groupingBy(AemTranslationObject::getSourcePath, Collectors.mapping(AemTranslationObject::getFileName, Collectors.toList())));
        Map<String, Long> joinedFilesIdMapping = projectResponse.getJobs().stream().filter(job -> "joinedFiles".equals(StringUtils.substringBeforeLast((String)job.getFileName(), (String)"."))).collect(Collectors.toMap(job -> StringUtils.substringAfterLast((String)job.getFileName(), (String)"."), job -> job.getJobId()));
        for (AemTranslationObject ato2 : input.getAemTranslationObjects()) {
            if (ato2.getXtmJobId() != null && ato2.getXtmJobId() > 0L) continue;
            Long xtmJobId = aemJobIds.getOrDefault(ato2.getSourcePath(), Collections.emptyList()).stream().map(xtmJobIds::get).filter(Objects::nonNull).filter(xtmId -> xtmId > 0L).findFirst().orElseGet(() -> xtmJobIds.getOrDefault(ato2.getFileName(), 0L));
            if (xtmJobId == 0L) {
                xtmJobId = joinedFilesIdMapping.getOrDefault(StringUtils.substringAfterLast((String)ato2.getFileName(), (String)"."), 0L);
            }
            ato2.setXtmJobId(xtmJobId);
        }
    }

    private static String removeUnderscoreFromDuplicatedXtmFilenames(String xtmFilename) {
        if (xtmFilename.contains("_") && xtmFilename.contains(".") && StringUtils.lastIndexOf((CharSequence)xtmFilename, (CharSequence)"_") < StringUtils.lastIndexOf((CharSequence)xtmFilename, (CharSequence)".")) {
            return StringUtils.substringBeforeLast((String)xtmFilename, (String)"_") + "." + StringUtils.substringAfterLast((String)xtmFilename, (String)".");
        }
        return xtmFilename;
    }

    private void sendPreviewToXtm(AemTranslationJob atj, PreviewZipFile previewZip) throws TranslationException {
        if (previewZip == null) {
            return;
        }
        this.restActionFactory.getAddPreviewAction(atj.getXtmProjectId(), previewZip, atj.getProject().getConfig()).run();
        this.restActionFactory.getProjectAnalysisCompletionAction(atj.getXtmProjectId(), atj.getProject().getConfig()).run();
    }

    public static AemTranslationJob get(ResourceResolver resourceResolver, String aemJobId) {
        Resource jobResource;
        String cachedPath = jobIdToJobPathCache.get(aemJobId);
        if (StringUtils.isNotBlank((CharSequence)cachedPath) && (jobResource = resourceResolver.getResource(cachedPath)) != null) {
            return (AemTranslationJob)jobResource.adaptTo(AemTranslationJob.class);
        }
        Resource root = resourceResolver.getResource("/var/xtm/translationJobs");
        if (root != null) {
            for (Resource jobResource2 : root.getChildren()) {
                if (!((String)jobResource2.getValueMap().get("aemJobId", (Object)"")).equals(aemJobId)) continue;
                AemTranslationJob aemTranslationJob = Objects.requireNonNull((AemTranslationJob)jobResource2.adaptTo(AemTranslationJob.class));
                jobIdToJobPathCache.put(aemJobId, aemTranslationJob.getPath());
                return aemTranslationJob;
            }
        }
        return null;
    }

    public static AemTranslationJob add(ResourceResolver resourceResolver, String aemJobId, String sourceLanguage, String targetLanguage, String xtmProjectName, String description, Date dueDate, TranslationConstants.TranslationStatus status) throws PersistenceException {
        if (StringUtils.isBlank((CharSequence)aemJobId) || TranslationJobController.get(resourceResolver, aemJobId) != null) {
            return null;
        }
        Resource jobRootResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)"/var/xtm/translationJobs", (String)"nt:unstructured", (String)"nt:unstructured", (boolean)false);
        String jobResourceName = ResourceUtil.createUniqueChildName((Resource)jobRootResource, (String)"job");
        Resource atjResource = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)("/var/xtm/translationJobs/" + jobResourceName), (String)"nt:unstructured", (String)"nt:unstructured", (boolean)false);
        ModifiableValueMap atjMvm = Objects.requireNonNull((ModifiableValueMap)atjResource.adaptTo(ModifiableValueMap.class));
        atjMvm.put((Object)"aemJobId", (Object)aemJobId);
        atjMvm.put((Object)"sourceLanguage", (Object)sourceLanguage);
        atjMvm.put((Object)"targetLanguage", (Object)targetLanguage);
        atjMvm.put((Object)"xtmProjectName", (Object)xtmProjectName);
        atjMvm.put((Object)"description", (Object)description);
        if (dueDate != null) {
            atjMvm.put((Object)"dueDate", (Object)dueDate);
        }
        atjMvm.put((Object)"translationStatusRaw", (Object)status.toString());
        atjMvm.put((Object)"sentToXtm", (Object)false);
        jobIdToJobPathCache.put(aemJobId, atjResource.getPath());
        return (AemTranslationJob)atjResource.adaptTo(AemTranslationJob.class);
    }
}

