/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.filename;

import com.adobe.granite.translation.api.TranslationObject;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.translation.connector.xtmforaem.api.FileNameStrategy;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;

public class PathBasedFileNameStrategy
implements FileNameStrategy {
    protected final TranslationObject translationObject;
    protected final TranslationCloudConfig cloudConfig;
    protected final AemTranslationJob atj;
    protected final String sourcePath;

    public PathBasedFileNameStrategy(TranslationObject translationObject, TranslationCloudConfig cloudConfig, AemTranslationJob atj) {
        this.translationObject = translationObject;
        this.cloudConfig = cloudConfig;
        this.atj = atj;
        this.sourcePath = this.getSourcePath(translationObject, cloudConfig, atj.getResource().getResourceResolver());
    }

    @Override
    public String getFileName() {
        return StringUtils.isNotBlank((CharSequence)this.sourcePath) ? this.sourcePath + ".xml" : null;
    }

    private String getSourcePath(TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig, ResourceResolver resourceResolver) {
        String rawPageSourcePath = translationObject.getTranslationObjectSourcePath();
        switch (xtmCloudConfig.getLaunchHandlingStrategy()) {
            case SEPARATE: {
                return rawPageSourcePath;
            }
            case AGGREGATE: {
                return StringUtils.startsWith((CharSequence)rawPageSourcePath, (CharSequence)"/content/launches/") ? this.getSourcePathFromLaunch(rawPageSourcePath, resourceResolver) : rawPageSourcePath;
            }
        }
        return "";
    }

    private String getSourcePathFromLaunch(String launchPath, ResourceResolver resourceResolver) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        return this.getLaunchRoot(pageManager.getPage(launchPath)).map(Page::getPath).map(rootPath -> StringUtils.substringAfter((String)launchPath, (String)rootPath)).orElse(launchPath);
    }

    private Optional<Page> getLaunchRoot(Page launchPage) {
        if (launchPage == null) {
            return Optional.empty();
        }
        Page currentPage = launchPage;
        while (currentPage.getParent() != null) {
            currentPage = currentPage.getParent();
        }
        return currentPage.getContentResource().isResourceType("wcm/launches/components/launch") ? Optional.of(currentPage) : Optional.empty();
    }
}

