/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.filename;

import com.adobe.granite.translation.api.TranslationObject;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.translation.connector.xtmforaem.api.FileNameStrategy;
import com.xtm.translation.connector.xtmforaem.core.impl.filename.PathBasedFileNameStrategy;
import org.apache.commons.lang3.StringUtils;

public class TitleAndHashFileNameStrategy
extends PathBasedFileNameStrategy
implements FileNameStrategy {
    public TitleAndHashFileNameStrategy(TranslationObject translationObject, TranslationCloudConfig cloudConfig, AemTranslationJob atj) {
        super(translationObject, cloudConfig, atj);
    }

    @Override
    public String getFileName() {
        String extension;
        String baseName;
        String targetLanguage = this.atj.getTargetLanguage();
        String title = this.translationObject.getTitle();
        int pathHash = this.sourcePath.hashCode() + targetLanguage.hashCode();
        String hashToken = Integer.toString(pathHash, 36);
        if ("text/html".equals(this.translationObject.getMimeType())) {
            baseName = title;
            extension = ".xml";
        } else {
            String filename = StringUtils.substringAfterLast((String)this.translationObject.getTranslationObjectSourcePath(), (String)"/");
            if (StringUtils.contains((CharSequence)filename, (CharSequence)".")) {
                baseName = StringUtils.substringBeforeLast((String)filename, (String)".");
                extension = "." + StringUtils.substringAfterLast((String)filename, (String)".");
            } else {
                baseName = filename;
                extension = "";
            }
        }
        return baseName + " [" + hashToken + "]" + extension;
    }
}

