/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.impl.filename;

import com.adobe.granite.translation.api.TranslationObject;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.config.XtmJobFileNamingStrategy;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.translation.connector.xtmforaem.api.FileNameFactory;
import com.xtm.translation.connector.xtmforaem.api.FileNameStrategy;
import com.xtm.translation.connector.xtmforaem.core.impl.filename.I18NFileNameStrategy;
import com.xtm.translation.connector.xtmforaem.core.impl.filename.PathBasedFileNameStrategy;
import com.xtm.translation.connector.xtmforaem.core.impl.filename.TitleAndHashFileNameStrategy;
import com.xtm.translation.connector.xtmforaem.core.impl.filename.TitleAndTimestampedHashFileNameStrategy;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileNameFactory.class}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class, field="$$scr$$dummy$$field")})
public class XtmFileNameFactory
implements FileNameFactory {
    private static final Logger log = LoggerFactory.getLogger(XtmFileNameFactory.class);

    @Override
    public FileNameStrategy getStrategy(TranslationObject translationObject, TranslationCloudConfig cloudConfig, AemTranslationJob atj) {
        String title = translationObject.getTitle();
        String targetLanguage = atj.getTargetLanguage();
        if (XtmFileNameFactory.isAssetOrTagsMetadata(title)) {
            return new TitleAndTimestampedHashFileNameStrategy(title, targetLanguage);
        }
        if (XtmFileNameFactory.isDictionary(title, targetLanguage)) {
            return new I18NFileNameStrategy(targetLanguage);
        }
        if (XtmFileNameFactory.isPathBasedStrategy(cloudConfig)) {
            return new PathBasedFileNameStrategy(translationObject, cloudConfig, atj);
        }
        if (XtmFileNameFactory.isTitleBasedStrategy(cloudConfig)) {
            return new TitleAndHashFileNameStrategy(translationObject, cloudConfig, atj);
        }
        throw new IllegalStateException("Unexpected strategy: '" + (Object)((Object)cloudConfig.getXtmJobFileNamingStrategy()) + "'");
    }

    private static boolean isAssetOrTagsMetadata(String title) {
        return "ASSETMETADATA".equals(title) || "TAGMETADATA".equals(title);
    }

    private static boolean isDictionary(String title, String targetLanguage) {
        String normTitle = StringUtils.replace((String)title, (String)"-", (String)"_");
        String normTargetLanguage = StringUtils.replace((String)targetLanguage, (String)"-", (String)"_");
        return StringUtils.equals((CharSequence)(normTargetLanguage + ".json"), (CharSequence)normTitle) || "I18NCOMPONENTSTRINGDICT".equals(title);
    }

    private static boolean isPathBasedStrategy(TranslationCloudConfig cloudConfig) {
        return XtmJobFileNamingStrategy.PATH_BASED.equals((Object)cloudConfig.getXtmJobFileNamingStrategy());
    }

    private static boolean isTitleBasedStrategy(TranslationCloudConfig cloudConfig) {
        return XtmJobFileNamingStrategy.TITLE_BASED.equals((Object)cloudConfig.getXtmJobFileNamingStrategy());
    }
}

