/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.translation.connector.xtmforaem.core.models;

import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.google.common.collect.ImmutableMap;
import com.xtm.aem.api.AuthorInstance;
import com.xtm.aem.api.config.PreviewGenerationStrategy;
import com.xtm.aem.api.config.TranslationCloudConfig;
import com.xtm.aem.api.xtm.AemTranslationJob;
import com.xtm.aem.api.xtm.AemTranslationObject;
import com.xtm.translation.connector.xtmforaem.api.FileNameFactory;
import com.xtm.translation.connector.xtmforaem.api.FileNameStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ComplexAemTranslationObjectCreator.class}, reference={@Reference(name="$$scr$$ignore", service=AuthorInstance.class)})
public class ComplexAemTranslationObjectCreator {
    private static final Logger log = LoggerFactory.getLogger(ComplexAemTranslationObjectCreator.class);
    public static final String NN_TRANSLATION_OBJECT = "translationObject";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private FileNameFactory fileNameFactory;

    public AemTranslationObject create(Resource translationJobResource, TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig) throws PersistenceException, TranslationException {
        AemTranslationJob atj = (AemTranslationJob)translationJobResource.adaptTo(AemTranslationJob.class);
        ResourceResolver resourceResolver = translationJobResource.getResourceResolver();
        Resource objectsRoot = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)(translationJobResource.getPath() + "/objects"), Collections.emptyMap(), null, (boolean)false);
        String atoResourceName = ResourceUtil.createUniqueChildName((Resource)objectsRoot, (String)NN_TRANSLATION_OBJECT);
        Resource atoResource = resourceResolver.create(objectsRoot, atoResourceName, Collections.emptyMap());
        ModifiableValueMap atoMvm = Objects.requireNonNull((ModifiableValueMap)atoResource.adaptTo(ModifiableValueMap.class));
        FileNameStrategy fileNameStrategy = this.fileNameFactory.getStrategy(translationObject, xtmCloudConfig, atj);
        atoMvm.put((Object)"fileName", (Object)fileNameStrategy.getFileName());
        atoMvm.put((Object)"aemTranslationObjectId", (Object)ComplexAemTranslationObjectCreator.getAtoId(translationObject, translationJobResource));
        this.addFile(atoResource, "file.xml", translationObject.getTranslationObjectXMLInputStream());
        this.handlePreviewFile(translationObject, xtmCloudConfig, atoResource);
        return (AemTranslationObject)atoResource.adaptTo(AemTranslationObject.class);
    }

    @NotNull
    private static String getAtoId(TranslationObject translationObject, Resource translationJobResource) {
        String aemJobId = (String)translationJobResource.getValueMap().get("aemJobId", String.class);
        if ("I18NCOMPONENTSTRINGDICT".equals(translationObject.getTitle())) {
            return "I18NCOMPONENTSTRINGDICT_" + StringUtils.substringAfterLast((String)aemJobId, (String)"_");
        }
        return translationObject.getTitle() + "_" + UUID.randomUUID();
    }

    private void handlePreviewFile(TranslationObject translationObject, TranslationCloudConfig xtmCloudConfig, Resource atoResource) throws PersistenceException {
        InputStream preview;
        if (PreviewGenerationStrategy.AEM.equals((Object)xtmCloudConfig.getPreviewGenerationStrategy()) && (preview = this.generatePreview(translationObject)) != null) {
            this.addFile(atoResource, "preview.zip", preview);
        }
    }

    private void addFile(Resource parent, String name, InputStream data) throws PersistenceException {
        ResourceResolver resourceResolver = parent.getResourceResolver();
        Resource fileResource = resourceResolver.create(parent, name, (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:file"));
        resourceResolver.create(fileResource, "jcr:content", (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)"nt:unstructured", (Object)"jcr:data", (Object)data));
    }

    private InputStream generatePreview(TranslationObject translationObject) {
        ZipInputStream zis = translationObject.getTranslationObjectPreview();
        if (zis != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream((OutputStream)baos);){
                ZipEntry entry;
                while (null != (entry = zis.getNextEntry())) {
                    zos.putNextEntry(entry);
                    IOUtils.copy((InputStream)zis, (OutputStream)zos);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            return baos.toInputStream();
        }
        return null;
    }

    private void setResourceResolverFactory(TranslationObject translationObject) {
        try {
            Class<?> cls = translationObject.getClass();
            Method setMethod = cls.getMethod("setResolverFactory", ResourceResolverFactory.class);
            setMethod.invoke((Object)translationObject, this.resourceResolverFactory);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Could not set instance of resource resolver factory into translation object '{}'", (Object)translationObject.getId(), (Object)e);
        }
    }
}

