/******************************************
 *
 * Copyright (c) 2003-2010 XML-INTL Ltd.
 *
 * All Rights Reserved
 *
 ******************************************/

/* global jQuery */
(function ($, document, Coral, ready) {
  "use strict";

  var initialized = false,
      summaryCard,
      failedTranslationJobs = [],
      ticketingSystemUrl = 'https://xtm-cloud.atlassian.net/servicedesk/customer/portal/4/user/login?destination=portal%2F4%2Fgroup%2F43',
      documentationUrl = 'https://help.xtm.cloud/connectors/en/xtm-connect---adobe-experience-manager.html'

  function init() {
    bindDOM();

    if (canProcess()) {
      addSupportDialog();
      failedTranslationJobs.forEach(addHelpMessage);
      bindEvents();
    }
  }

  function bindDOM() {
    summaryCard = document.querySelector('.cq-projects-translation-summary-Pod').parentElement;
    document.querySelectorAll('.cq-translation-pod')
        .forEach(function (elem) {
              if (elem.parentElement.querySelector('coral-alert')) {
                failedTranslationJobs.push(elem.parentElement);
              }
            }
        )
  }

  function bindEvents() {
    $('.xtm-support-button').click(showSupportDialog);
  }

  function addSupportDialog() {
    var dialog = new Coral.Dialog().set({
      id: 'xtmSupportDialog',
      header: {
        innerHTML: 'XTM Support Request'
      },
      content: {
        innerHTML: getSupportDialogContent(),
      },
      footer: {
        innerHTML: '<button is="coral-button" variant="primary" onclick="window.open(\''+ ticketingSystemUrl +'\',\'_blank\')">Raise a ticket</button>'
            + '<button is="coral-button" variant="secondary" coral-close>OK</button>'
      }
    });
    document.body.appendChild(dialog);
  }

  function getSupportDialogContent() {
    var projectPath = summaryCard.getAttribute('data-projectpath');

    return '<p>' +
        '  Please read <a' +
        '   href="' + documentationUrl + '"' +
        '    target="_blank">this documentation</a> which might help resolve the issue you are experiencing.' +
        '</p>' +
        '<p>' +
        '  You can report your issue by <a href="' + ticketingSystemUrl + '" target="_blank">creating a ticket</a> using our ticket system. Add the details listed below to your ticket to help us investigate your issue:' +
        '  <ol>' +
        '    <li>' +
        '      Download the <a href="https://experienceleague.adobe.com/docs/experience-manager-65/deploying/configuring/configure-logging.html?lang=en" target="_blank">AEM' +
        '      logs</a> and attach them to the ticket.' +
        '    </li>' +
        '    <li>' +
        '      Download the output from the <a href="' + getXtmDebugLink(projectPath) + '" target="_blank">XTM debug servlet</a> and attach it to the ticket.' +
        '    </li>' +
        '    <li>' +
        '     To speed up resolution of your ticket, please include the following information:' +
        '      <ol>' +
        '        <li>AEM version (including used Service Pack or AEM SDK version)</li>' +
        '        <li>XTM Connect - AEM version</li>' +
        '        <li>XTM Cloud version</li>' +
        '        <li>Screenshots or video recording</li>' +
        '      </ol>' +
        '    </li>' +
        '  </ol>' +
        '</p>';
  }

  function showSupportDialog() {
    document.querySelector('#xtmSupportDialog').show();
  }

  function addHelpMessage(translationJobElem) {
    var alertContainer = translationJobElem.querySelector('coral-alert').parentElement;

    var helpMessage = new Coral.Alert().set({
      style: 'min-width: inherit',
      variant: 'info',
      size: 'L',
      header: {
        innerHTML: 'XTM Support needed?',
      },
      content: {
        innerHTML: '<p>In case you require XTM support please click on the button below.</p>'
            + '<button class="xtm-support-button" is="coral-button" variant="primary">Get support</button>',
      },
    });

    alertContainer.append(helpMessage);
    alertContainer.setAttribute('style', 'padding:8px;')
  }

  function getXtmDebugLink(projectPath) {
    return projectPath + '.xtmdebug.xtmdownload.json';
  }

  function canProcess() {
    return failedTranslationJobs.length > 0
        && Array.from(summaryCard.querySelectorAll('.cq-translation-summary-description > span'))
            .find(function (el) {
              return el.textContent.toLowerCase() === 'xtm-connector';
            });
  }

  $(document).on('foundation-contentloaded', function () {
    if (!initialized) {
      ready(this, init);
    }
    initialized = true;
  });
})(jQuery, document, Coral, Coral.commons.ready);