/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.api.config;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.xtm.aem.api.raw.RawTranslationPage;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;

public enum LaunchHandlingStrategy {
    SEPARATE(LaunchHandlingStrategy::separateSourcePathGetter),
    AGGREGATE(LaunchHandlingStrategy::aggregateSourcePathGetter);

    private final BiFunction<RawTranslationPage, ResourceResolver, String> sourcePathGetter;

    private LaunchHandlingStrategy(BiFunction<RawTranslationPage, ResourceResolver, String> sourcePathGetter) {
        this.sourcePathGetter = sourcePathGetter;
    }

    public String getSourcePath(RawTranslationPage page, ResourceResolver resourceResolver) {
        return this.sourcePathGetter.apply(page, resourceResolver);
    }

    private static String separateSourcePathGetter(RawTranslationPage page, ResourceResolver resourceResolver) {
        return page.getSourcePath();
    }

    private static String aggregateSourcePathGetter(RawTranslationPage page, ResourceResolver resourceResolver) {
        String rawPageSourcePath = page.getSourcePath();
        return StringUtils.startsWith((CharSequence)rawPageSourcePath, (CharSequence)"/content/launches/") ? LaunchHandlingStrategy.getSourcePathFromLaunch(rawPageSourcePath, resourceResolver) : rawPageSourcePath;
    }

    private static String getSourcePathFromLaunch(String launchPath, ResourceResolver resourceResolver) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        return LaunchHandlingStrategy.getLaunchRoot(pageManager.getPage(launchPath)).map(Page::getPath).map(rootPath -> StringUtils.substringAfter((String)launchPath, (String)rootPath)).orElse(launchPath);
    }

    private static Optional<Page> getLaunchRoot(Page launchPage) {
        if (launchPage == null) {
            return Optional.empty();
        }
        Page currentPage = launchPage;
        while (currentPage.getParent() != null) {
            currentPage = currentPage.getParent();
        }
        return currentPage.getContentResource().isResourceType("wcm/launches/components/launch") ? Optional.of(currentPage) : Optional.empty();
    }
}

