/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.ProjectEstimates;
import com.xtm.aem.rest.openapi.model.RSFindProjectPostRequest;
import com.xtm.aem.rest.openapi.model.RSProjectCloneResponse;
import com.xtm.aem.rest.openapi.model.RSProjectCreationResponse;
import com.xtm.aem.rest.openapi.model.RSProjectDeletionResponse;
import com.xtm.aem.rest.openapi.model.RSProjectGetResponse;
import com.xtm.aem.rest.openapi.model.RSProjectResponse;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesAddRequest;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesAddResponse;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesDeleteRequest;
import com.xtm.aem.rest.openapi.model.RSProjectTargetLanguagesDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSProjectUpdateRequest;
import com.xtm.aem.rest.openapi.model.RSProjectUpdateResponse;
import com.xtm.aem.rest.openapi.model.RSProjectsMultiCreationResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProjectsApi {
    private ApiClient apiClient;

    public ProjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSProjectTargetLanguagesAddResponse addTargetLanguagesUsingPOST(String authorization, Long projectId, RSProjectTargetLanguagesAddRequest targetLanguagesAddRequest) throws ApiException {
        RSProjectTargetLanguagesAddRequest localVarPostBody = targetLanguagesAddRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling addTargetLanguagesUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling addTargetLanguagesUsingPOST");
        }
        if (targetLanguagesAddRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'targetLanguagesAddRequest' when calling addTargetLanguagesUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/target-languages".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectTargetLanguagesAddResponse> localVarReturnType = new TypeReference<RSProjectTargetLanguagesAddResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectCloneResponse cloneProjectUsingPOST(String authorization, Long originId, String name) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling cloneProjectUsingPOST");
        }
        if (originId == null) {
            throw new ApiException(400, "Missing the required parameter 'originId' when calling cloneProjectUsingPOST");
        }
        String localVarPath = "/projects/clone";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (originId != null) {
            localVarFormParams.put("originId", originId);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectCloneResponse> localVarReturnType = new TypeReference<RSProjectCloneResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectsMultiCreationResponse createMultiProjectsUsingPOST(String authorization, Long customerId, String name, File translationFiles0File, String callbacksAnalysisFinishedCallback, String callbacksJobFinishedCallback, String callbacksProjectFinishedCallback, String callbacksWorkflowTransitionCallback, String description, String dueDate, Long externalCreatorId, String fileProcessType, String filesTargetLanguagesGrouping, String filterTemplateId, Integer groupFilesDitaLevel, String groupFilesType, File referenceFiles0File, String referenceFiles0Name, Long templateId, String translationFiles0Metadata, String translationFiles0MetadataType, String translationFiles0Name, String translationFiles0SourceLanguage, List<Long> translationFiles0TagIds, List<String> translationFiles0TargetLanguages, String translationFiles0TargetLanguagesV20Code, Long translationFiles0TargetLanguagesV20WorkflowId, String translationFiles0TranslationType, Long translationFiles0WorkflowId, Long workflowId, String workflowName) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling createMultiProjectsUsingPOST");
        }
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling createMultiProjectsUsingPOST");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling createMultiProjectsUsingPOST");
        }
        if (translationFiles0File == null) {
            throw new ApiException(400, "Missing the required parameter 'translationFiles0File' when calling createMultiProjectsUsingPOST");
        }
        String localVarPath = "/projects/multi-create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (customerId != null) {
            localVarFormParams.put("customerId", customerId);
        }
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (translationFiles0File != null) {
            localVarFormParams.put("translationFiles[0].file", translationFiles0File);
        }
        if (callbacksAnalysisFinishedCallback != null) {
            localVarFormParams.put("callbacks.analysisFinishedCallback", callbacksAnalysisFinishedCallback);
        }
        if (callbacksJobFinishedCallback != null) {
            localVarFormParams.put("callbacks.jobFinishedCallback", callbacksJobFinishedCallback);
        }
        if (callbacksProjectFinishedCallback != null) {
            localVarFormParams.put("callbacks.projectFinishedCallback", callbacksProjectFinishedCallback);
        }
        if (callbacksWorkflowTransitionCallback != null) {
            localVarFormParams.put("callbacks.workflowTransitionCallback", callbacksWorkflowTransitionCallback);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (dueDate != null) {
            localVarFormParams.put("dueDate", dueDate);
        }
        if (externalCreatorId != null) {
            localVarFormParams.put("externalCreatorId", externalCreatorId);
        }
        if (fileProcessType != null) {
            localVarFormParams.put("fileProcessType", fileProcessType);
        }
        if (filesTargetLanguagesGrouping != null) {
            localVarFormParams.put("filesTargetLanguagesGrouping", filesTargetLanguagesGrouping);
        }
        if (filterTemplateId != null) {
            localVarFormParams.put("filterTemplateId", filterTemplateId);
        }
        if (groupFilesDitaLevel != null) {
            localVarFormParams.put("groupFilesDitaLevel", groupFilesDitaLevel);
        }
        if (groupFilesType != null) {
            localVarFormParams.put("groupFilesType", groupFilesType);
        }
        if (referenceFiles0File != null) {
            localVarFormParams.put("referenceFiles[0].file", referenceFiles0File);
        }
        if (referenceFiles0Name != null) {
            localVarFormParams.put("referenceFiles[0].name", referenceFiles0Name);
        }
        if (templateId != null) {
            localVarFormParams.put("templateId", templateId);
        }
        if (translationFiles0Metadata != null) {
            localVarFormParams.put("translationFiles[0].metadata", translationFiles0Metadata);
        }
        if (translationFiles0MetadataType != null) {
            localVarFormParams.put("translationFiles[0].metadataType", translationFiles0MetadataType);
        }
        if (translationFiles0Name != null) {
            localVarFormParams.put("translationFiles[0].name", translationFiles0Name);
        }
        if (translationFiles0SourceLanguage != null) {
            localVarFormParams.put("translationFiles[0].sourceLanguage", translationFiles0SourceLanguage);
        }
        if (translationFiles0TagIds != null) {
            localVarFormParams.put("translationFiles[0].tagIds", translationFiles0TagIds);
        }
        if (translationFiles0TargetLanguages != null) {
            localVarFormParams.put("translationFiles[0].targetLanguages", translationFiles0TargetLanguages);
        }
        if (translationFiles0TargetLanguagesV20Code != null) {
            localVarFormParams.put("translationFiles[0].targetLanguagesV2[0].code", translationFiles0TargetLanguagesV20Code);
        }
        if (translationFiles0TargetLanguagesV20WorkflowId != null) {
            localVarFormParams.put("translationFiles[0].targetLanguagesV2[0].workflowId", translationFiles0TargetLanguagesV20WorkflowId);
        }
        if (translationFiles0TranslationType != null) {
            localVarFormParams.put("translationFiles[0].translationType", translationFiles0TranslationType);
        }
        if (translationFiles0WorkflowId != null) {
            localVarFormParams.put("translationFiles[0].workflowId", translationFiles0WorkflowId);
        }
        if (workflowId != null) {
            localVarFormParams.put("workflowId", workflowId);
        }
        if (workflowName != null) {
            localVarFormParams.put("workflowName", workflowName);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectsMultiCreationResponse> localVarReturnType = new TypeReference<RSProjectsMultiCreationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectCreationResponse createProjectUsingPOST(String authorization, Long customerId, String name, String callbacksAnalysisFinishedCallback, String callbacksJobFinishedCallback, String callbacksProjectFinishedCallback, String callbacksWorkflowTransitionCallback, String description, String dueDate, String errorActionDuplicateName, Long externalCreatorId, String fileProcessType, String filterTemplateId, Integer groupFilesDitaLevel, String groupFilesType, String newSourceLanguage, Long newSourceWorkflowId, String newSourceWorkflowName, List<String> overrideFieldsOverrideFromRequest, String projectManagerType, File referenceFiles0File, String referenceFiles0Name, String referenceId, String sourceLanguage, List<String> targetLanguages, Long templateId, File translationFiles0File, String translationFiles0Metadata, String translationFiles0MetadataType, String translationFiles0Name, List<Long> translationFiles0TagIds, List<String> translationFiles0TargetLanguages, String translationFiles0TargetLanguagesV20Code, Long translationFiles0TargetLanguagesV20WorkflowId, String translationFiles0TranslationType, Long translationFiles0WorkflowId, Long workflowId, String workflowName) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling createProjectUsingPOST");
        }
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling createProjectUsingPOST");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling createProjectUsingPOST");
        }
        String localVarPath = "/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (customerId != null) {
            localVarFormParams.put("customerId", customerId);
        }
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (callbacksAnalysisFinishedCallback != null) {
            localVarFormParams.put("callbacks.analysisFinishedCallback", callbacksAnalysisFinishedCallback);
        }
        if (callbacksJobFinishedCallback != null) {
            localVarFormParams.put("callbacks.jobFinishedCallback", callbacksJobFinishedCallback);
        }
        if (callbacksProjectFinishedCallback != null) {
            localVarFormParams.put("callbacks.projectFinishedCallback", callbacksProjectFinishedCallback);
        }
        if (callbacksWorkflowTransitionCallback != null) {
            localVarFormParams.put("callbacks.workflowTransitionCallback", callbacksWorkflowTransitionCallback);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (dueDate != null) {
            localVarFormParams.put("dueDate", dueDate);
        }
        if (errorActionDuplicateName != null) {
            localVarFormParams.put("errorAction.duplicateName", errorActionDuplicateName);
        }
        if (externalCreatorId != null) {
            localVarFormParams.put("externalCreatorId", externalCreatorId);
        }
        if (fileProcessType != null) {
            localVarFormParams.put("fileProcessType", fileProcessType);
        }
        if (filterTemplateId != null) {
            localVarFormParams.put("filterTemplateId", filterTemplateId);
        }
        if (groupFilesDitaLevel != null) {
            localVarFormParams.put("groupFilesDitaLevel", groupFilesDitaLevel);
        }
        if (groupFilesType != null) {
            localVarFormParams.put("groupFilesType", groupFilesType);
        }
        if (newSourceLanguage != null) {
            localVarFormParams.put("newSourceLanguage", newSourceLanguage);
        }
        if (newSourceWorkflowId != null) {
            localVarFormParams.put("newSourceWorkflowId", newSourceWorkflowId);
        }
        if (newSourceWorkflowName != null) {
            localVarFormParams.put("newSourceWorkflowName", newSourceWorkflowName);
        }
        if (overrideFieldsOverrideFromRequest != null) {
            localVarFormParams.put("overrideFields.overrideFromRequest", overrideFieldsOverrideFromRequest);
        }
        if (projectManagerType != null) {
            localVarFormParams.put("projectManagerType", projectManagerType);
        }
        if (referenceFiles0File != null) {
            localVarFormParams.put("referenceFiles[0].file", referenceFiles0File);
        }
        if (referenceFiles0Name != null) {
            localVarFormParams.put("referenceFiles[0].name", referenceFiles0Name);
        }
        if (referenceId != null) {
            localVarFormParams.put("referenceId", referenceId);
        }
        if (sourceLanguage != null) {
            localVarFormParams.put("sourceLanguage", sourceLanguage);
        }
        if (targetLanguages != null) {
            localVarFormParams.put("targetLanguages", targetLanguages);
        }
        if (templateId != null) {
            localVarFormParams.put("templateId", templateId);
        }
        if (translationFiles0File != null) {
            localVarFormParams.put("translationFiles[0].file", translationFiles0File);
        }
        if (translationFiles0Metadata != null) {
            localVarFormParams.put("translationFiles[0].metadata", translationFiles0Metadata);
        }
        if (translationFiles0MetadataType != null) {
            localVarFormParams.put("translationFiles[0].metadataType", translationFiles0MetadataType);
        }
        if (translationFiles0Name != null) {
            localVarFormParams.put("translationFiles[0].name", translationFiles0Name);
        }
        if (translationFiles0TagIds != null) {
            localVarFormParams.put("translationFiles[0].tagIds", translationFiles0TagIds);
        }
        if (translationFiles0TargetLanguages != null) {
            localVarFormParams.put("translationFiles[0].targetLanguages", translationFiles0TargetLanguages);
        }
        if (translationFiles0TargetLanguagesV20Code != null) {
            localVarFormParams.put("translationFiles[0].targetLanguagesV2[0].code", translationFiles0TargetLanguagesV20Code);
        }
        if (translationFiles0TargetLanguagesV20WorkflowId != null) {
            localVarFormParams.put("translationFiles[0].targetLanguagesV2[0].workflowId", translationFiles0TargetLanguagesV20WorkflowId);
        }
        if (translationFiles0TranslationType != null) {
            localVarFormParams.put("translationFiles[0].translationType", translationFiles0TranslationType);
        }
        if (translationFiles0WorkflowId != null) {
            localVarFormParams.put("translationFiles[0].workflowId", translationFiles0WorkflowId);
        }
        if (workflowId != null) {
            localVarFormParams.put("workflowId", workflowId);
        }
        if (workflowName != null) {
            localVarFormParams.put("workflowName", workflowName);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectCreationResponse> localVarReturnType = new TypeReference<RSProjectCreationResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectDeletionResponse deleteProjectUsingDELETE(String authorization, Long projectId, String option) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deleteProjectUsingDELETE");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling deleteProjectUsingDELETE");
        }
        String localVarPath = "/projects/{projectId}".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("option", option));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectDeletionResponse> localVarReturnType = new TypeReference<RSProjectDeletionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectTargetLanguagesDeleteResponse deleteTargetLanguagesUsingDELETE(String authorization, Long projectId, RSProjectTargetLanguagesDeleteRequest targetLanguagesAddRequest) throws ApiException {
        RSProjectTargetLanguagesDeleteRequest localVarPostBody = targetLanguagesAddRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deleteTargetLanguagesUsingDELETE");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling deleteTargetLanguagesUsingDELETE");
        }
        if (targetLanguagesAddRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'targetLanguagesAddRequest' when calling deleteTargetLanguagesUsingDELETE");
        }
        String localVarPath = "/projects/{projectId}/target-languages".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectTargetLanguagesDeleteResponse> localVarReturnType = new TypeReference<RSProjectTargetLanguagesDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProjectEstimates findProposalUsingGET(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findProposalUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling findProposalUsingGET");
        }
        String localVarPath = "/projects/{projectId}/proposal".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<ProjectEstimates> localVarReturnType = new TypeReference<ProjectEstimates>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectGetResponse getProjectUsingGET(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getProjectUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getProjectUsingGET");
        }
        String localVarPath = "/projects/{projectId}".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectGetResponse> localVarReturnType = new TypeReference<RSProjectGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSProjectResponse> getProjectsUsingGET(String authorization, List<String> activity, String createdDateFrom, String createdDateTo, List<Long> customerIds, List<Long> externalIds, String finishedDateFrom, String finishedDateTo, List<Long> ids, String modifiedDateFrom, String modifiedDateTo, String name, Integer page, Integer pageSize, String sort, String status) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getProjectsUsingGET");
        }
        String localVarPath = "/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "activity", activity));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdDateFrom", createdDateFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdDateTo", createdDateTo));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "customerIds", customerIds));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "externalIds", externalIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedDateFrom", finishedDateFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedDateTo", finishedDateTo));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedDateFrom", modifiedDateFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedDateTo", modifiedDateTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSProjectResponse>> localVarReturnType = new TypeReference<List<RSProjectResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSProjectResponse> postProjectsSearchUsingPOST(String authorization, RSFindProjectPostRequest findProjectPostRequest) throws ApiException {
        RSFindProjectPostRequest localVarPostBody = findProjectPostRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling postProjectsSearchUsingPOST");
        }
        if (findProjectPostRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'findProjectPostRequest' when calling postProjectsSearchUsingPOST");
        }
        String localVarPath = "/projects/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSProjectResponse>> localVarReturnType = new TypeReference<List<RSProjectResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectUpdateResponse updateProjectPatchUsingPATCH(String authorization, Long projectId, RSProjectUpdateRequest projectUpdateRequest) throws ApiException {
        RSProjectUpdateRequest localVarPostBody = projectUpdateRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling updateProjectPatchUsingPATCH");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling updateProjectPatchUsingPATCH");
        }
        if (projectUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'projectUpdateRequest' when calling updateProjectPatchUsingPATCH");
        }
        String localVarPath = "/projects/{projectId}".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectUpdateResponse> localVarReturnType = new TypeReference<RSProjectUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectUpdateResponse updateProjectUsingPUT(String authorization, Long projectId, RSProjectUpdateRequest projectUpdateRequest, String updateFieldsType) throws ApiException {
        RSProjectUpdateRequest localVarPostBody = projectUpdateRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling updateProjectUsingPUT");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling updateProjectUsingPUT");
        }
        if (projectUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'projectUpdateRequest' when calling updateProjectUsingPUT");
        }
        String localVarPath = "/projects/{projectId}".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updateFieldsType", updateFieldsType));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectUpdateResponse> localVarReturnType = new TypeReference<RSProjectUpdateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

