/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSCreateTagsRequest;
import com.xtm.aem.rest.openapi.model.RSTagCreateResponse;
import com.xtm.aem.rest.openapi.model.RSTagDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSTagFindResponse;
import com.xtm.aem.rest.openapi.model.RSTagGetResponse;
import com.xtm.aem.rest.openapi.model.RSTagPatchRequest;
import com.xtm.aem.rest.openapi.model.RSTagPatchResponse;
import com.xtm.aem.rest.openapi.model.RSTagPutRequest;
import com.xtm.aem.rest.openapi.model.RSTagPutResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TagsApi {
    private ApiClient apiClient;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSTagCreateResponse createTagsUsingPOST(String authorization, Long tagGroupId, RSCreateTagsRequest createTagsRequest) throws ApiException {
        RSCreateTagsRequest localVarPostBody = createTagsRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling createTagsUsingPOST");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling createTagsUsingPOST");
        }
        if (createTagsRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createTagsRequest' when calling createTagsUsingPOST");
        }
        String localVarPath = "/tag-groups/{tagGroupId}/tags".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagCreateResponse> localVarReturnType = new TypeReference<RSTagCreateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagDeleteResponse deleteTagUsingDELETE(String authorization, Long tagGroupId, Long tagId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deleteTagUsingDELETE");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling deleteTagUsingDELETE");
        }
        if (tagId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagId' when calling deleteTagUsingDELETE");
        }
        String localVarPath = "/tag-groups/{tagGroupId}/tags/{tagId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString())).replaceAll("\\{tagId\\}", this.apiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagDeleteResponse> localVarReturnType = new TypeReference<RSTagDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSTagFindResponse> obtainGroupTagsUsingGET(String authorization, Long tagGroupId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling obtainGroupTagsUsingGET");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling obtainGroupTagsUsingGET");
        }
        String localVarPath = "/tag-groups/{tagGroupId}/tags".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSTagFindResponse>> localVarReturnType = new TypeReference<List<RSTagFindResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagGetResponse obtainTagGroupUsingGET(String authorization, Long tagGroupId, Long tagId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling obtainTagGroupUsingGET");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling obtainTagGroupUsingGET");
        }
        if (tagId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagId' when calling obtainTagGroupUsingGET");
        }
        String localVarPath = "/tag-groups/{tagGroupId}/tags/{tagId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString())).replaceAll("\\{tagId\\}", this.apiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagGetResponse> localVarReturnType = new TypeReference<RSTagGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagPatchResponse patchTagParamUsingPATCH(String authorization, Long tagGroupId, Long tagId, RSTagPatchRequest toPatch) throws ApiException {
        RSTagPatchRequest localVarPostBody = toPatch;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchTagParamUsingPATCH");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling patchTagParamUsingPATCH");
        }
        if (tagId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagId' when calling patchTagParamUsingPATCH");
        }
        if (toPatch == null) {
            throw new ApiException(400, "Missing the required parameter 'toPatch' when calling patchTagParamUsingPATCH");
        }
        String localVarPath = "/tag-groups/{tagGroupId}/tags/{tagId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString())).replaceAll("\\{tagId\\}", this.apiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagPatchResponse> localVarReturnType = new TypeReference<RSTagPatchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagPutResponse putTagUsingPUT(String authorization, Long tagGroupId, Long tagId, RSTagPutRequest toUpdate) throws ApiException {
        RSTagPutRequest localVarPostBody = toUpdate;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling putTagUsingPUT");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling putTagUsingPUT");
        }
        if (tagId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagId' when calling putTagUsingPUT");
        }
        if (toUpdate == null) {
            throw new ApiException(400, "Missing the required parameter 'toUpdate' when calling putTagUsingPUT");
        }
        String localVarPath = "/tag-groups/{tagGroupId}/tags/{tagId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString())).replaceAll("\\{tagId\\}", this.apiClient.escapeString(tagId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagPutResponse> localVarReturnType = new TypeReference<RSTagPutResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

