/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.JavaTimeFormatter;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.RFC3339DateFormat;
import com.xtm.aem.rest.openapi.ServerConfiguration;
import com.xtm.aem.rest.openapi.ServerVariable;
import com.xtm.aem.rest.openapi.StringUtil;
import com.xtm.aem.rest.openapi.auth.Authentication;
import com.xtm.aem.rest.openapi.auth.OAuth;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ApiClient
extends JavaTimeFormatter {
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private Map<String, String> defaultCookieMap = new HashMap<String, String>();
    private String basePath = "http://localhost/project-manager-api-rest";
    protected List<ServerConfiguration> servers = new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("/project-manager-api-rest", "No description provided", new HashMap<String, ServerVariable>())));
    protected Integer serverIndex = 0;
    protected Map<String, String> serverVariables = null;
    private boolean debugging = false;
    private int connectionTimeout = 0;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper = new ObjectMapper();
    protected String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;
    private static List<String> bodyMethods = Arrays.asList("POST", "PUT", "DELETE", "PATCH");

    public ApiClient(CloseableHttpClient httpClient) {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.setDateFormat(ApiClient.buildDefaultDateFormat());
        this.dateFormat = ApiClient.buildDefaultDateFormat();
        this.setUserAgent("OpenAPI-Generator/2.1.0-SNAPSHOT/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("Roles", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.httpClient = httpClient;
    }

    public ApiClient() {
        this(HttpClients.createDefault());
    }

    public static DateFormat buildDefaultDateFormat() {
        return new RFC3339DateFormat();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ApiClient setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public List<ServerConfiguration> getServers() {
        return this.servers;
    }

    public ApiClient setServers(List<ServerConfiguration> servers) {
        this.servers = servers;
        return this;
    }

    public Integer getServerIndex() {
        return this.serverIndex;
    }

    public ApiClient setServerIndex(Integer serverIndex) {
        this.serverIndex = serverIndex;
        return this;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public ApiClient setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookieMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.objectMapper.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    protected Map<String, List<String>> transformResponseHeaders(Header[] headers) {
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
        for (Header header : headers) {
            ArrayList<String> valuesList = (ArrayList<String>)headersMap.get(header.getName());
            if (valuesList != null) {
                valuesList.add(header.getValue());
                continue;
            }
            valuesList = new ArrayList<String>();
            valuesList.add(header.getValue());
            headersMap.put(header.getName(), valuesList);
        }
        return headersMap;
    }

    private ContentType getContentType(String headerValue) throws ApiException {
        try {
            return ContentType.parse((String)headerValue);
        }
        catch (org.apache.http.ParseException e) {
            throw new ApiException("Could not parse content type " + headerValue);
        }
    }

    private String getResponseMimeType(HttpResponse response) throws ApiException {
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            return this.getContentType(contentTypeHeader.getValue()).getMimeType();
        }
        return null;
    }

    public HttpEntity serialize(Object obj, Map<String, Object> formParams, ContentType contentType) throws ApiException {
        String mimeType = contentType.getMimeType();
        if (this.isJsonMime(mimeType)) {
            try {
                return new StringEntity(this.objectMapper.writeValueAsString(obj), contentType);
            }
            catch (JsonProcessingException e) {
                throw new ApiException(e);
            }
        }
        if (mimeType.equals(ContentType.MULTIPART_FORM_DATA.getMimeType())) {
            MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
            for (Map.Entry<String, Object> paramEntry : formParams.entrySet()) {
                Object value = paramEntry.getValue();
                if (value instanceof File) {
                    multiPartBuilder.addBinaryBody(paramEntry.getKey(), (File)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    multiPartBuilder.addBinaryBody(paramEntry.getKey(), (byte[])value);
                    continue;
                }
                multiPartBuilder.addTextBody(paramEntry.getKey(), this.parameterToString(paramEntry.getValue()));
            }
            return multiPartBuilder.build();
        }
        if (mimeType.equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            ArrayList<BasicNameValuePair> formValues = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> paramEntry : formParams.entrySet()) {
                formValues.add(new BasicNameValuePair(paramEntry.getKey(), this.parameterToString(paramEntry.getValue())));
            }
            try {
                return new UrlEncodedFormEntity(formValues);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiException(e);
            }
        }
        if (obj instanceof File) {
            return new FileEntity((File)obj, contentType);
        }
        if (obj instanceof byte[]) {
            return new ByteArrayEntity((byte[])obj, contentType);
        }
        throw new ApiException("Serialization for content type '" + contentType + "' not supported");
    }

    public <T> T deserialize(HttpResponse response, TypeReference<T> valueType) throws ApiException, IOException {
        if (valueType == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        Type valueRawType = valueType.getType();
        if (valueRawType.equals(byte[].class)) {
            return (T)EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (valueRawType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        String mimeType = this.getResponseMimeType(response);
        if (mimeType == null || this.isJsonMime(mimeType)) {
            return (T)this.objectMapper.readValue(entity.getContent(), valueType);
        }
        throw new ApiException("Deserialization for content type '" + mimeType + "' not supported for type '" + valueType + "'", response.getStatusLine().getStatusCode(), this.responseHeaders, EntityUtils.toString((HttpEntity)entity));
    }

    private File downloadFileFromResponse(HttpResponse response) throws IOException {
        Header contentDispositionHeader = response.getFirstHeader("Content-Disposition");
        String contentDisposition = contentDispositionHeader == null ? null : contentDispositionHeader.getValue();
        File file = this.prepareDownloadFile(contentDisposition);
        Files.copy(response.getEntity().getContent(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return file;
    }

    protected File prepareDownloadFile(String contentDisposition) throws IOException {
        String prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(Paths.get(this.tempFolderPath, new String[0]), prefix, suffix, new FileAttribute[0]).toFile();
    }

    private String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        String value;
        String prefix;
        String baseURL;
        if (this.serverIndex != null) {
            if (this.serverIndex < 0 || this.serverIndex >= this.servers.size()) {
                throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", this.serverIndex, this.servers.size()));
            }
            baseURL = this.servers.get(this.serverIndex).URL(this.serverVariables);
        } else {
            baseURL = this.basePath;
        }
        StringBuilder url = new StringBuilder();
        url.append(baseURL).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        return url.toString();
    }

    protected boolean isSuccessfulStatus(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    protected boolean isBodyAllowed(String method) {
        return bodyMethods.contains(method);
    }

    protected Cookie buildCookie(String key, String value, URI uri) {
        BasicClientCookie cookie = new BasicClientCookie(key, value);
        cookie.setDomain(uri.getHost());
        cookie.setPath("/");
        return cookie;
    }

    protected <T> T processResponse(CloseableHttpResponse response, TypeReference<T> returnType) throws ApiException, IOException {
        this.statusCode = response.getStatusLine().getStatusCode();
        if (this.statusCode == 204) {
            return null;
        }
        this.responseHeaders = this.transformResponseHeaders(response.getAllHeaders());
        if (this.isSuccessfulStatus(this.statusCode)) {
            return this.deserialize((HttpResponse)response, returnType);
        }
        String message = EntityUtils.toString((HttpEntity)response.getEntity());
        throw new ApiException(message, this.statusCode, this.responseHeaders, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, TypeReference<T> returnType) throws ApiException {
        if (body != null && !formParams.isEmpty()) {
            throw new ApiException("Cannot have body and form params");
        }
        this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
        String url = this.buildUrl(path, queryParams, collectionQueryParams);
        RequestBuilder builder = RequestBuilder.create((String)method);
        builder.setUri(url);
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(this.connectionTimeout).build();
        builder.setConfig(config);
        if (accept != null) {
            builder.addHeader("Accept", accept);
        }
        for (Map.Entry<String, String> entry : headerParams.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(entry.getKey())) continue;
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        BasicCookieStore store = new BasicCookieStore();
        for (Map.Entry<String, String> keyValue : cookieParams.entrySet()) {
            store.addCookie(this.buildCookie(keyValue.getKey(), keyValue.getValue(), builder.getUri()));
        }
        for (Map.Entry<String, String> keyValue : this.defaultCookieMap.entrySet()) {
            if (cookieParams.containsKey(keyValue.getKey())) continue;
            store.addCookie(this.buildCookie(keyValue.getKey(), keyValue.getValue(), builder.getUri()));
        }
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setCookieStore((CookieStore)store);
        ContentType contentTypeObj = this.getContentType(contentType);
        if (body != null || !formParams.isEmpty()) {
            if (!this.isBodyAllowed(method)) throw new ApiException("method " + method + " does not support a request body");
            builder.setEntity(this.serialize(body, formParams, contentTypeObj));
        }
        try (CloseableHttpResponse response = this.httpClient.execute(builder.build(), (HttpContext)httpClientContext);){
            T t = this.processResponse(response, returnType);
            return t;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, cookieParams);
        }
    }
}

