/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.CUSTOMERLANGUAGECOMBINATIONS;
import com.xtm.aem.rest.openapi.model.RSCreateCustomerResponse;
import com.xtm.aem.rest.openapi.model.RSCreateCustomerTO;
import com.xtm.aem.rest.openapi.model.RSFindCustomerResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomersApi {
    private ApiClient apiClient;

    public CustomersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSCreateCustomerResponse createCustomerUsingPOST(String authorization, RSCreateCustomerTO request) throws ApiException {
        RSCreateCustomerTO localVarPostBody = request;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling createCustomerUsingPOST");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling createCustomerUsingPOST");
        }
        String localVarPath = "/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSCreateCustomerResponse> localVarReturnType = new TypeReference<RSCreateCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<CUSTOMERLANGUAGECOMBINATIONS> customerLangCombinationsUsingGET(String authorization, Long customerId, String fetchLangDefinitions) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling customerLangCombinationsUsingGET");
        }
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling customerLangCombinationsUsingGET");
        }
        String localVarPath = "/customers/{customerId}/language-combinations".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fetchLangDefinitions", fetchLangDefinitions));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<CUSTOMERLANGUAGECOMBINATIONS>> localVarReturnType = new TypeReference<List<CUSTOMERLANGUAGECOMBINATIONS>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSFindCustomerResponse> getCustomersUsingGET(String authorization, String activity, String fetchAddress, List<Long> ids, List<String> names) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getCustomersUsingGET");
        }
        String localVarPath = "/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activity", activity));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fetchAddress", fetchAddress));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "names", names));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSFindCustomerResponse>> localVarReturnType = new TypeReference<List<RSFindCustomerResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

