/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSProjectFileDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileGenerateRequest;
import com.xtm.aem.rest.openapi.model.RSProjectFileGenerateResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileRemoveParameter;
import com.xtm.aem.rest.openapi.model.RSProjectFileStatusResponse;
import com.xtm.aem.rest.openapi.model.RSProjectFileUploadResponse;
import com.xtm.aem.rest.openapi.model.RSTranslationFileStatusResponse;
import com.xtm.aem.rest.openapi.model.RSTranslationFilesUploadResponse;
import com.xtm.aem.rest.openapi.model.RSUploadPreviewFileResponse;
import com.xtm.aem.rest.openapi.model.RSUploadReferenceMaterialsResponse;
import com.xtm.aem.rest.openapi.model.RSUploadSegmentIdImageResponse;
import com.xtm.aem.rest.overrides.ParamsBuilder;
import com.xtm.aem.rest.overrides.ParamsUtils;
import com.xtm.aem.rest.overrides.ProjectFilesApiMatchType;
import com.xtm.aem.rest.overrides.RestApiConstants;
import com.xtm.aem.rest.overrides.YesNoType;
import com.xtm.aem.rest.overrides.model.ProjectTranslationFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectFilesApi {
    private ApiClient apiClient;

    public ProjectFilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectFilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSTranslationFileStatusResponse checkUploadStatusUsingGET(String authorization, Long fileId, String fileType, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling checkUploadStatusUsingGET");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling checkUploadStatusUsingGET");
        }
        if (fileType == null) {
            throw new ApiException(400, "Missing the required parameter 'fileType' when calling checkUploadStatusUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling checkUploadStatusUsingGET");
        }
        String localVarPath = "/projects/{projectId}/files/translations/{fileId}/status".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileType", fileType));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTranslationFileStatusResponse> localVarReturnType = new TypeReference<RSTranslationFileStatusResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectFileDeleteResponse deleteSourceFilesFromProjectUsingDELETE(String authorization, Long projectId, List<RSProjectFileRemoveParameter> filesToRemove, String reanalyseProjectDecision) throws ApiException {
        List<RSProjectFileRemoveParameter> localVarPostBody = filesToRemove;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deleteSourceFilesFromProjectUsingDELETE");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling deleteSourceFilesFromProjectUsingDELETE");
        }
        if (filesToRemove == null) {
            throw new ApiException(400, "Missing the required parameter 'filesToRemove' when calling deleteSourceFilesFromProjectUsingDELETE");
        }
        String localVarPath = "/projects/{projectId}/files".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("reanalyseProjectDecision", reanalyseProjectDecision));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectFileDeleteResponse> localVarReturnType = new TypeReference<RSProjectFileDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void downloadFileUsingGET(String authorization, Long fileId, String fileScope, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadFileUsingGET");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling downloadFileUsingGET");
        }
        if (fileScope == null) {
            throw new ApiException(400, "Missing the required parameter 'fileScope' when calling downloadFileUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling downloadFileUsingGET");
        }
        String localVarPath = "/projects/{projectId}/files/{fileId}/download".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileScope", fileScope));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void downloadFilesUsingGET(String authorization, String fileScope, String fileType, Long projectId, List<Long> fileIds, String fileNameFilter, String fileNameFilterType, List<Long> jobIds, List<String> targetLanguages) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadFilesUsingGET");
        }
        if (fileScope == null) {
            throw new ApiException(400, "Missing the required parameter 'fileScope' when calling downloadFilesUsingGET");
        }
        if (fileType == null) {
            throw new ApiException(400, "Missing the required parameter 'fileType' when calling downloadFilesUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling downloadFilesUsingGET");
        }
        String localVarPath = "/projects/{projectId}/files/download".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileScope", fileScope));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileType", fileType));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fileIds", fileIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileNameFilter", fileNameFilter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileNameFilterType", fileNameFilterType));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void downloadSourcesFileUsingGET(String authorization, Long projectId, List<Long> jobIds) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadSourcesFileUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling downloadSourcesFileUsingGET");
        }
        String localVarPath = "/projects/{projectId}/files/sources/download".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public RSProjectFileStatusResponse fileStatusUsingGET(String authorization, Long fileId, String fileScope, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling fileStatusUsingGET");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling fileStatusUsingGET");
        }
        if (fileScope == null) {
            throw new ApiException(400, "Missing the required parameter 'fileScope' when calling fileStatusUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling fileStatusUsingGET");
        }
        String localVarPath = "/projects/{projectId}/files/{fileId}/status".replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileScope", fileScope));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectFileStatusResponse> localVarReturnType = new TypeReference<RSProjectFileStatusResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSProjectFileStatusResponse> filesStatusUsingGET(String authorization, String fileScope, Long projectId, List<Long> fileIds, String fileType, List<Long> jobIds, List<String> targetLanguages) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling filesStatusUsingGET");
        }
        if (fileScope == null) {
            throw new ApiException(400, "Missing the required parameter 'fileScope' when calling filesStatusUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling filesStatusUsingGET");
        }
        String localVarPath = "/projects/{projectId}/files/status".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileScope", fileScope));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fileIds", fileIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileType", fileType));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "targetLanguages", targetLanguages));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSProjectFileStatusResponse>> localVarReturnType = new TypeReference<List<RSProjectFileStatusResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSProjectFileGenerateResponse> generateFilesUsingPOST(String authorization, String fileType, Long projectId, List<Long> jobIds, String targetLanguage, RSProjectFileGenerateRequest request) throws ApiException {
        RSProjectFileGenerateRequest localVarPostBody = request;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling generateFilesUsingPOST");
        }
        if (fileType == null) {
            throw new ApiException(400, "Missing the required parameter 'fileType' when calling generateFilesUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling generateFilesUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/files/generate".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fileType", fileType));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("targetLanguage", targetLanguage));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSProjectFileGenerateResponse>> localVarReturnType = new TypeReference<List<RSProjectFileGenerateResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSUploadPreviewFileResponse uploadPreviewFileUsingPOST(String authorization, Long projectId, File previewFiles0File, String previewFiles0Name) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling uploadPreviewFileUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling uploadPreviewFileUsingPOST");
        }
        if (previewFiles0File == null) {
            throw new ApiException(400, "Missing the required parameter 'previewFiles0File' when calling uploadPreviewFileUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/files/preview-files/upload".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (previewFiles0File != null) {
            localVarFormParams.put("previewFiles[0].file", previewFiles0File);
        }
        if (previewFiles0Name != null) {
            localVarFormParams.put("previewFiles[0].name", previewFiles0Name);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSUploadPreviewFileResponse> localVarReturnType = new TypeReference<RSUploadPreviewFileResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSUploadReferenceMaterialsResponse uploadReferenceMaterialsUsingPOST(String authorization, Long projectId, File referenceMaterialsFiles0File, String referenceMaterialsFiles0Name) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling uploadReferenceMaterialsUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling uploadReferenceMaterialsUsingPOST");
        }
        if (referenceMaterialsFiles0File == null) {
            throw new ApiException(400, "Missing the required parameter 'referenceMaterialsFiles0File' when calling uploadReferenceMaterialsUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/files/reference-materials/upload".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (referenceMaterialsFiles0File != null) {
            localVarFormParams.put("referenceMaterialsFiles[0].file", referenceMaterialsFiles0File);
        }
        if (referenceMaterialsFiles0Name != null) {
            localVarFormParams.put("referenceMaterialsFiles[0].name", referenceMaterialsFiles0Name);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSUploadReferenceMaterialsResponse> localVarReturnType = new TypeReference<RSUploadReferenceMaterialsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSUploadSegmentIdImageResponse uploadSegmentIdImagesUsingPOST(String authorization, Long projectId, File segmentIdImageFiles0File, String segmentIdImageFiles0Name) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling uploadSegmentIdImagesUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling uploadSegmentIdImagesUsingPOST");
        }
        if (segmentIdImageFiles0File == null) {
            throw new ApiException(400, "Missing the required parameter 'segmentIdImageFiles0File' when calling uploadSegmentIdImagesUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/files/segment-id-images/upload".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (segmentIdImageFiles0File != null) {
            localVarFormParams.put("segmentIdImageFiles[0].file", segmentIdImageFiles0File);
        }
        if (segmentIdImageFiles0Name != null) {
            localVarFormParams.put("segmentIdImageFiles[0].name", segmentIdImageFiles0Name);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSUploadSegmentIdImageResponse> localVarReturnType = new TypeReference<RSUploadSegmentIdImageResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectFileUploadResponse uploadSourceFilesUsingPOST(String authorization, Long projectId, List<ProjectTranslationFile> translationFiles, ProjectFilesApiMatchType matchType, YesNoType reanalyseProject) throws ApiException {
        String methodName = "uploadSourceFilesUsingPOST";
        ParamsUtils.ensureParameterIsSet(authorization, "authorization", "uploadSourceFilesUsingPOST");
        ParamsUtils.ensureParameterIsSet(projectId, "projectId", "uploadSourceFilesUsingPOST");
        ParamsUtils.ensureParameterIsSet(translationFiles, "translationFiles", "uploadSourceFilesUsingPOST");
        String localVarPath = "/projects/{projectId}/files/sources/upload".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = ParamsUtils.getDefaultHeaders(authorization, this.apiClient);
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        Map<String, Object> baseParams = new ParamsBuilder().addIfNotEmpty("matchType", (Object)matchType).addIfNotEmpty("reanalyseProject", (Object)reanalyseProject).build();
        localVarFormParams.putAll(baseParams);
        localVarFormParams.putAll(ParamsUtils.populateTranslationFiles(translationFiles, "files"));
        String localVarAccept = this.apiClient.selectHeaderAccept(RestApiConstants.VAR_MIME_TYPE_APPLICATION_JSON);
        String localVarContentType = this.apiClient.selectHeaderContentType(RestApiConstants.VAR_CONTENT_TYPE_MULTIPART_FORM_DATA);
        TypeReference<RSProjectFileUploadResponse> localVarReturnType = new TypeReference<RSProjectFileUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, null, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, RestApiConstants.VAR_AUTH_NAMES, localVarReturnType);
    }

    public RSTranslationFilesUploadResponse uploadTranslationFileUsingPOST(String authorization, Long projectId, String fileType, Long jobId, File translationFileFile, String workflowStepName, String xliffOptionsAutopopulation, String xliffOptionsSegmentStatusApproving, String translationFileName) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling uploadTranslationFileUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling uploadTranslationFileUsingPOST");
        }
        if (fileType == null) {
            throw new ApiException(400, "Missing the required parameter 'fileType' when calling uploadTranslationFileUsingPOST");
        }
        if (jobId == null) {
            throw new ApiException(400, "Missing the required parameter 'jobId' when calling uploadTranslationFileUsingPOST");
        }
        if (translationFileFile == null) {
            throw new ApiException(400, "Missing the required parameter 'translationFileFile' when calling uploadTranslationFileUsingPOST");
        }
        if (workflowStepName == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowStepName' when calling uploadTranslationFileUsingPOST");
        }
        if (xliffOptionsAutopopulation == null) {
            throw new ApiException(400, "Missing the required parameter 'xliffOptionsAutopopulation' when calling uploadTranslationFileUsingPOST");
        }
        if (xliffOptionsSegmentStatusApproving == null) {
            throw new ApiException(400, "Missing the required parameter 'xliffOptionsSegmentStatusApproving' when calling uploadTranslationFileUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/files/translations/upload".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        if (fileType != null) {
            localVarFormParams.put("fileType", fileType);
        }
        if (jobId != null) {
            localVarFormParams.put("jobId", jobId);
        }
        if (translationFileFile != null) {
            localVarFormParams.put("translationFile.file", translationFileFile);
        }
        if (translationFileName != null) {
            localVarFormParams.put("translationFile.name", translationFileName);
        }
        if (workflowStepName != null) {
            localVarFormParams.put("workflowStepName", workflowStepName);
        }
        if (xliffOptionsAutopopulation != null) {
            localVarFormParams.put("xliffOptions.autopopulation", xliffOptionsAutopopulation);
        }
        if (xliffOptionsSegmentStatusApproving != null) {
            localVarFormParams.put("xliffOptions.segmentStatusApproving", xliffOptionsSegmentStatusApproving);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTranslationFilesUploadResponse> localVarReturnType = new TypeReference<RSTranslationFilesUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

