/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSCostsGenerateRequest;
import com.xtm.aem.rest.openapi.model.RSCostsGenerateResponse;
import com.xtm.aem.rest.openapi.model.RSCostsResponse;
import com.xtm.aem.rest.openapi.model.RSGeneratePORequest;
import com.xtm.aem.rest.openapi.model.RSPOResponse;
import com.xtm.aem.rest.openapi.model.RSProjectCostsGeneratePOResponse;
import java.util.ArrayList;
import java.util.HashMap;

public class ProjectCostsApi {
    private ApiClient apiClient;

    public ProjectCostsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectCostsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSPOResponse downloadPOUsingGET(String authorization, Long costId, String processId, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling downloadPOUsingGET");
        }
        if (costId == null) {
            throw new ApiException(400, "Missing the required parameter 'costId' when calling downloadPOUsingGET");
        }
        if (processId == null) {
            throw new ApiException(400, "Missing the required parameter 'processId' when calling downloadPOUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling downloadPOUsingGET");
        }
        String localVarPath = "/projects/{projectId}/costs/{costId}/pos".replaceAll("\\{costId\\}", this.apiClient.escapeString(costId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processId", processId));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSPOResponse> localVarReturnType = new TypeReference<RSPOResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSCostsGenerateResponse generateCostsUsingPOST(String authorization, Long projectId, RSCostsGenerateRequest costsGenerateRequest) throws ApiException {
        RSCostsGenerateRequest localVarPostBody = costsGenerateRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling generateCostsUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling generateCostsUsingPOST");
        }
        if (costsGenerateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'costsGenerateRequest' when calling generateCostsUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/costs".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSCostsGenerateResponse> localVarReturnType = new TypeReference<RSCostsGenerateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectCostsGeneratePOResponse generatePOUsingPOST(String authorization, String calculationMethod, Long costId, String costsBreakdown, Long projectId, Long userId, String includeRates, RSGeneratePORequest request) throws ApiException {
        RSGeneratePORequest localVarPostBody = request;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling generatePOUsingPOST");
        }
        if (calculationMethod == null) {
            throw new ApiException(400, "Missing the required parameter 'calculationMethod' when calling generatePOUsingPOST");
        }
        if (costId == null) {
            throw new ApiException(400, "Missing the required parameter 'costId' when calling generatePOUsingPOST");
        }
        if (costsBreakdown == null) {
            throw new ApiException(400, "Missing the required parameter 'costsBreakdown' when calling generatePOUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling generatePOUsingPOST");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling generatePOUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/costs/{costId}/pos".replaceAll("\\{costId\\}", this.apiClient.escapeString(costId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("calculationMethod", calculationMethod));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("costsBreakdown", costsBreakdown));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeRates", includeRates));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("userId", userId));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectCostsGeneratePOResponse> localVarReturnType = new TypeReference<RSProjectCostsGeneratePOResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSCostsResponse obtainCostsUsingGET(String authorization, Long costId, Long projectId, String fetchLevel) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling obtainCostsUsingGET");
        }
        if (costId == null) {
            throw new ApiException(400, "Missing the required parameter 'costId' when calling obtainCostsUsingGET");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling obtainCostsUsingGET");
        }
        String localVarPath = "/projects/{projectId}/costs/{costId}".replaceAll("\\{costId\\}", this.apiClient.escapeString(costId.toString())).replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fetchLevel", fetchLevel));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSCostsResponse> localVarReturnType = new TypeReference<RSCostsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

