/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSActivateProjectResponse;
import com.xtm.aem.rest.openapi.model.RSArchiveProjectResponse;
import com.xtm.aem.rest.openapi.model.RSProjectDeactivateResponse;
import com.xtm.aem.rest.openapi.model.RSProjectJobCancelResponse;
import com.xtm.aem.rest.openapi.model.RSProjectsReanalyzeResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProjectActivityApi {
    private ApiClient apiClient;

    public ProjectActivityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectActivityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSActivateProjectResponse activateProjectUsingPOST(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling activateProjectUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling activateProjectUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/activate".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSActivateProjectResponse> localVarReturnType = new TypeReference<RSActivateProjectResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSArchiveProjectResponse archiveProjectUsingPOST(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling archiveProjectUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling archiveProjectUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/archive".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSArchiveProjectResponse> localVarReturnType = new TypeReference<RSArchiveProjectResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectJobCancelResponse cancelJobUsingPOST(String authorization, List<Long> jobIds, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling cancelJobUsingPOST");
        }
        if (jobIds == null) {
            throw new ApiException(400, "Missing the required parameter 'jobIds' when calling cancelJobUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling cancelJobUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/jobs/cancel".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "jobIds", jobIds));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectJobCancelResponse> localVarReturnType = new TypeReference<RSProjectJobCancelResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectDeactivateResponse deactivateProjectUsingPOST(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deactivateProjectUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling deactivateProjectUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/deactivate".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectDeactivateResponse> localVarReturnType = new TypeReference<RSProjectDeactivateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSProjectsReanalyzeResponse reanalyzeProjectUsingPOST(String authorization, Long projectId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling reanalyzeProjectUsingPOST");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling reanalyzeProjectUsingPOST");
        }
        String localVarPath = "/projects/{projectId}/reanalyze".replaceAll("\\{projectId\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSProjectsReanalyzeResponse> localVarReturnType = new TypeReference<RSProjectsReanalyzeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

