/*
 * Decompiled with CFR 0.152.
 */
package com.xtm.aem.rest.openapi.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xtm.aem.rest.openapi.ApiClient;
import com.xtm.aem.rest.openapi.ApiException;
import com.xtm.aem.rest.openapi.Configuration;
import com.xtm.aem.rest.openapi.Pair;
import com.xtm.aem.rest.openapi.model.RSTagGroupCreateRequest;
import com.xtm.aem.rest.openapi.model.RSTagGroupCreateResponse;
import com.xtm.aem.rest.openapi.model.RSTagGroupDeleteResponse;
import com.xtm.aem.rest.openapi.model.RSTagGroupFindResponse;
import com.xtm.aem.rest.openapi.model.RSTagGroupGetResponse;
import com.xtm.aem.rest.openapi.model.RSTagGroupPatchRequest;
import com.xtm.aem.rest.openapi.model.RSTagGroupPatchResponse;
import com.xtm.aem.rest.openapi.model.RSTagGroupPutRequest;
import com.xtm.aem.rest.openapi.model.RSTagGroupPutResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TagGroupsApi {
    private ApiClient apiClient;

    public TagGroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagGroupsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RSTagGroupCreateResponse createTagGroupUsingPOST(String authorization, RSTagGroupCreateRequest request) throws ApiException {
        RSTagGroupCreateRequest localVarPostBody = request;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling createTagGroupUsingPOST");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling createTagGroupUsingPOST");
        }
        String localVarPath = "/tag-groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagGroupCreateResponse> localVarReturnType = new TypeReference<RSTagGroupCreateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagGroupDeleteResponse deleteTagGroupUsingDELETE(String authorization, Long tagGroupId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling deleteTagGroupUsingDELETE");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling deleteTagGroupUsingDELETE");
        }
        String localVarPath = "/tag-groups/{tagGroupId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagGroupDeleteResponse> localVarReturnType = new TypeReference<RSTagGroupDeleteResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<RSTagGroupFindResponse> findTagGroupsUsingGET(String authorization, List<Long> ids) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling findTagGroupsUsingGET");
        }
        String localVarPath = "/tag-groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "ids", ids));
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<List<RSTagGroupFindResponse>> localVarReturnType = new TypeReference<List<RSTagGroupFindResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagGroupGetResponse getTagGroupUsingGET(String authorization, Long tagGroupId) throws ApiException {
        Object localVarPostBody = null;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling getTagGroupUsingGET");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling getTagGroupUsingGET");
        }
        String localVarPath = "/tag-groups/{tagGroupId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagGroupGetResponse> localVarReturnType = new TypeReference<RSTagGroupGetResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagGroupPatchResponse patchTagGroupUsingPATCH(String authorization, Long tagGroupId, RSTagGroupPatchRequest tagGroupPatchRequest) throws ApiException {
        RSTagGroupPatchRequest localVarPostBody = tagGroupPatchRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling patchTagGroupUsingPATCH");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling patchTagGroupUsingPATCH");
        }
        if (tagGroupPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupPatchRequest' when calling patchTagGroupUsingPATCH");
        }
        String localVarPath = "/tag-groups/{tagGroupId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagGroupPatchResponse> localVarReturnType = new TypeReference<RSTagGroupPatchResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RSTagGroupPutResponse putTagGroupUsingPUT(String authorization, Long tagGroupId, RSTagGroupPutRequest tagGroupPutRequest) throws ApiException {
        RSTagGroupPutRequest localVarPostBody = tagGroupPutRequest;
        if (authorization == null) {
            throw new ApiException(400, "Missing the required parameter 'authorization' when calling putTagGroupUsingPUT");
        }
        if (tagGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupId' when calling putTagGroupUsingPUT");
        }
        if (tagGroupPutRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'tagGroupPutRequest' when calling putTagGroupUsingPUT");
        }
        String localVarPath = "/tag-groups/{tagGroupId}".replaceAll("\\{tagGroupId\\}", this.apiClient.escapeString(tagGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.apiClient.parameterToString(authorization));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"Roles"};
        TypeReference<RSTagGroupPutResponse> localVarReturnType = new TypeReference<RSTagGroupPutResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

