/******************************************
 *
 * Copyright (c) 2003-2010 XML-INTL Ltd.
 *
 * All Rights Reserved
 *
 ******************************************/

/* global jQuery */

(function ($, document, ready) {
  "use strict";

  var form,
      projectNameInput,
      sourceLanguageInput,
      targetLanguageInput,
      dueDatePicker,
      includeSubPagesCheckbox,
      autoStartProjectCheckbox,
      pagePathInput,
      errorDialog,
      jobTranslationPath,
      xtmConfigInput;

  function init() {
    bindDOM();
    bindEvents();
  }

  function bindDOM() {
    form = document.querySelector('form');
    projectNameInput = document.querySelector("[name='xtmProjectName']");
    sourceLanguageInput = document.querySelector("[name='xtmSourceLanguage']");
    targetLanguageInput = document.querySelector("[name='xtmTargetLanguage']");
    dueDatePicker = document.querySelector("[name='xtmDueDate']")
    includeSubPagesCheckbox = document.querySelector("[name='xtmIncludeSubPages']");
    autoStartProjectCheckbox = document.querySelector("[name='xtmAutoStartProject']");
    pagePathInput = document.querySelector("[name='xtmPagePath']");
    xtmConfigInput = document.querySelector("[name='xtmConfig']");
    errorDialog = document.querySelector('#error-dialog');
  }

  function bindEvents() {
    $(document).on('submit.publishWizard', '.cq-siteadmin-admin-send-to-translation-in-xtm-form', onFormSubmit);
  }

  function getData() {
    var data = $(form).serializeArray();
    data.push({name: 'xtmConfig', value: xtmConfigInput.value});
    return data
  }

  function createTranslationProject(data) {
    return $.ajax({
      type: "POST",
      url: '/services/xtm/xtm-translation-project',
      data: data
    }).fail(handleError);
  }

  function addTranslationPages(createdProject) {
    var targetLanguage = targetLanguageInput.selectedItem.value;
    jobTranslationPath = createdProject.languageToTranslationJobPath[targetLanguage];

    var data = new FormData();
    data.append(":translationJobPath", jobTranslationPath);
    data.append("_charset_", "UTF-8");
    data.append("createLanguageCopy", "true");
    data.append(":operation", "ADD_TRANSLATION_PAGES");
    data.append("allowChildren", includeSubPagesCheckbox.checked);
    data.append("translationpage", pagePathInput.value);

    return $.ajax({
      type: "POST",
      url: jobTranslationPath,
      enctype: 'multipart/form-data',
      data: data,
      processData: false,
      contentType: false
    }).fail(handleError);
  }

  function startProject() {
    if (autoStartProjectCheckbox.checked) {
      var data = new FormData();
      data.append(":translationJobPath", jobTranslationPath);
      data.append(":operation", "START_TRANSLATION");

      return $.ajax({
        type: "POST",
        url: jobTranslationPath,
        enctype: 'multipart/form-data',
        data: data,
        processData: false,
        contentType: false,
      }).fail(handleError);
    }
  }

  function handleSuccess() {
    document.location = '/editor.html' + pagePathInput.value + '.html';
  }

  function togglePreloader() {
    var elem = document.querySelector('.foundation-ui-mask');
    if (!elem) {
      var preloader = document.createElement('div');
      var wait = new Coral.Wait().set({
        size: "L",
        centered: true
      });
      preloader.setAttribute('class', 'foundation-ui-mask');
      preloader.append(wait);
      document.body.append(preloader);
    } else {
      elem.remove();
    }
  }

  function onFormSubmit(e) {
    e.preventDefault();
    var submitButton = e.target[0];

    submitButton.setAttribute('disabled', 'disabled');
    togglePreloader();

    createTranslationProject(getData())
        .then(addTranslationPages)
        .then(startProject)
        .then(handleSuccess)
        .finally(() => {
          togglePreloader();
          submitButton.removeAttribute('disabled');
        });
  }

  function handleError(e) {
    var errorTitle = e.statusText || 'Error';
    var errorText = e.responseText || 'Unknown error';
    var title = errorDialog.querySelector('.coral3-Dialog-header > div');
    var content = errorDialog.querySelector('.coral3-Dialog-content > div');
    title.innerText = errorTitle;
    content.innerText = errorText;
    console.error(errorText, e);
    errorDialog.show();
  }

  $(document).on('foundation-contentloaded', function () {
    ready(this, init);
  });
})(jQuery, document, Coral.commons.ready);
