import {expect, type Page} from "@playwright/test";

export default class BasePage {

  protected readonly path: string;
  protected readonly page: Page;
  protected readonly waitForSelector: string;
  protected baseUrl: string;

  constructor(page: Page, path: string, waitForSelector: string) {
    this.page = page;
    this.path = path;
    this.waitForSelector = waitForSelector;
    this.baseUrl = process.env.AEM_AUTHOR_URL;
  }

  async open() {
    const response = await this.page.goto(`${this.baseUrl}${this.path}`);
    await expect(response.status()).toEqual(200);
  }

  async waitForPageLoad() {
    if (this.waitForSelector) {
      await this.page.waitForSelector(this.waitForSelector);
    }
  }
}