import {expect, Locator} from "@playwright/test";
export default class CoralPathfieldComponent {

  private readonly element: Locator;
  private readonly input: Locator;
  private readonly list: Locator;

  constructor(element: Locator) {
    this.element = element;
    this.input = element.locator('input[is="coral-textfield"]');
    this.list = element.locator('coral-buttonlist');
  }

  async fill(value: string) {
    await this.element.click();
    await this.input.page().keyboard.type(value);
    await expect(this.list).toBeVisible();
    await this.list.locator('button').first().click();
    await expect(this.input).toHaveValue(value);
  }
}