import BasePage from "./BasePage";
import {expect, Locator, Page} from "@playwright/test";
import TranslationJobCardComponent from "./TranslationJobCardComponent";

export default class ProjectPage extends BasePage {
  private readonly translationJobsLocator: Locator;
  private readonly translationJobs: TranslationJobCardComponent[] = [];

  constructor(page: Page) {
    const path = new URL(page.url()).pathname;
    super(page, path, '.cq-projects-CardDashboard');
    this.translationJobsLocator = page.locator('.cq-projects-CardDashboard')
        .filter({hasText: 'Translation Job'});
  }

  async addTranslationResources(paths: string[]) {
    await this.getTranslationJobs();
    for (const translationJob of this.translationJobs) {
      await translationJob.addTranslationResources(paths);
    }
    await this.open();
  }

  async startAllJobs() {
    await this.getTranslationJobs();
    for (const translationJob of this.translationJobs) {
      await translationJob.startJob();
    }
    await this.page.reload();
  }

  async waitForAllJobsToFinish() {
    await this.getTranslationJobs();
    for (const translationJob of this.translationJobs) {
      await translationJob.waitForJobToFinish();
    }
  }

  private async getTranslationJobs() {
    if (this.translationJobs.length === 0) {
      const translationJobElements = await this.translationJobsLocator.all();
      for (const elem of translationJobElements) {
        this.translationJobs.push(new TranslationJobCardComponent(elem));
      }
    }
    return this.translationJobs;
  }
}