import {expect, test as setup} from '@playwright/test';
import {AUTH_FILE_AEM} from "./consts";

const LOGIN_PAGE_PATH = '/libs/granite/core/content/login.html';

setup('Authenticate AEM', async ({page}) => {
  await page.goto(`${process.env.AEM_AUTHOR_URL}${LOGIN_PAGE_PATH}`);

  const accordionButton = page.getByRole('button', {name: 'Sign in locally (admin tasks only)'});
  const usernameField = page.getByPlaceholder('User name');
  const passwordField = page.getByPlaceholder('Password', {exact: true});
  const loginButton = page.getByRole('button', {name: 'Sign In', exact: true});

  if (await accordionButton.isVisible()) {
    await accordionButton.click();
    await expect(usernameField).toBeVisible();
    await expect(passwordField).toBeVisible();
    await expect(loginButton).toBeVisible();
  }

  await usernameField.fill(process.env.AEM_AUTHOR_USERNAME);
  await passwordField.fill(process.env.AEM_AUTHOR_PASSWORD);
  await loginButton.click();

  await page.waitForURL(`${process.env.AEM_AUTHOR_URL}/aem/start.html`);
  await page.context().storageState({path: AUTH_FILE_AEM});
});